package com.liquidnet.service.galaxy.router.strategy.biz;

import com.liquidnet.common.third.antchain.constant.AntchainEnum;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftEnum;
import com.liquidnet.service.galaxy.constant.GalaxyConstant;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyConstantBiz
 * @Package com.liquidnet.service.galaxy.router.strategy
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/22 12:11
 */
public class GalaxyEnumBiz {

    /**
     * 任务状态转换
     * @param routerTypeEnum
     * @param code
     * @return
     */
    public static GalaxyConstant.TaskStatusEnum getTaskStatusEnum(GalaxyConstant.RouterTypeEnum routerTypeEnum, String code){
        GalaxyConstant.TaskStatusEnum taskStatusEnum = null;
        switch (routerTypeEnum.getCode()){
            case "zxinchain":
                if(code.equalsIgnoreCase(ZxlnftEnum.TaskStatusEnum.PROCESSING.getCode())){
                    taskStatusEnum = GalaxyConstant.TaskStatusEnum.PROCESSING;
                    break;
                }else if(code.equalsIgnoreCase(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                    taskStatusEnum = GalaxyConstant.TaskStatusEnum.TASK_SUCCESS;
                    break;
                }else if(code.equalsIgnoreCase(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())){
                    taskStatusEnum = GalaxyConstant.TaskStatusEnum.TASK_FAIL;
                    break;
                }
            case "antchain":
                if(code.equalsIgnoreCase(AntchainEnum.TaskStatusEnum.PROCESSING.getCode())){
                    taskStatusEnum = GalaxyConstant.TaskStatusEnum.PROCESSING;
                    break;
                }else if(code.equalsIgnoreCase(AntchainEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                    taskStatusEnum = GalaxyConstant.TaskStatusEnum.TASK_SUCCESS;
                    break;
                }else if(code.equalsIgnoreCase(AntchainEnum.TaskStatusEnum.TASK_FAIL.getCode())){
                    taskStatusEnum = GalaxyConstant.TaskStatusEnum.TASK_FAIL;
                    break;
                }
        }
        return taskStatusEnum;
    }

    /**
     * 用户绑定状态
     * @param routerType
     * @param code
     * @return
     */
    public static GalaxyConstant.UserBindStatusEnum getUserBindStatusEnum(String routerType, String code) {
        GalaxyConstant.UserBindStatusEnum userBindStatusEnum = null;
        switch (routerType) {
            case "zxinchain":
                if (code.equalsIgnoreCase(ZxlnftEnum.UserBindStatusEnum.BIND_PROCESSING.getCode())) {
                    userBindStatusEnum = GalaxyConstant.UserBindStatusEnum.BIND_PROCESSING;
                    break;
                } else if (code.equalsIgnoreCase(ZxlnftEnum.UserBindStatusEnum.BIND_SUCCESS.getCode())) {
                    userBindStatusEnum = GalaxyConstant.UserBindStatusEnum.BIND_SUCCESS;
                    break;
                } else if (code.equalsIgnoreCase(ZxlnftEnum.UserBindStatusEnum.BIND_FAIL.getCode())) {
                    userBindStatusEnum = GalaxyConstant.UserBindStatusEnum.BIND_FAIL;
                    break;
                } else if (code.equalsIgnoreCase(ZxlnftEnum.UserBindStatusEnum.BIND_CANNOT_QUERY.getCode())) {
                    userBindStatusEnum = GalaxyConstant.UserBindStatusEnum.BIND_CANNOT_QUERY;
                    break;
                }
            case "antchain":
                if (code.equalsIgnoreCase(AntchainEnum.UserBindStatusEnum.BIND_PROCESSING.getCode())) {
                    userBindStatusEnum = GalaxyConstant.UserBindStatusEnum.BIND_PROCESSING;
                    break;
                } else if (code.equalsIgnoreCase(AntchainEnum.UserBindStatusEnum.BIND_SUCCESS.getCode())) {
                    userBindStatusEnum = GalaxyConstant.UserBindStatusEnum.BIND_SUCCESS;
                    break;
                } else if (code.equalsIgnoreCase(AntchainEnum.UserBindStatusEnum.BIND_FAIL.getCode())) {
                    userBindStatusEnum = GalaxyConstant.UserBindStatusEnum.BIND_FAIL;
                    break;
                } else if (code.equalsIgnoreCase(AntchainEnum.UserBindStatusEnum.BIND_CANNOT_QUERY.getCode())) {
                    userBindStatusEnum = GalaxyConstant.UserBindStatusEnum.BIND_CANNOT_QUERY;
                    break;
                }
        }
        return userBindStatusEnum;
    }
}
