package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.BsonUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.entity.AdamUserInfo;
import com.liquidnet.service.adam.mapper.AdamUserInfoMapper;
import com.liquidnet.service.adam.service.IAdamUserInfoService;
import com.liquidnet.service.base.SqlMapping;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import org.bson.Document;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 用户信息 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@Service
public class AdamUserInfoServiceImpl extends ServiceImpl<AdamUserInfoMapper, AdamUserInfo> implements IAdamUserInfoService {
    @Autowired
    MongoConverter mongoConverter;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public void edit(AdamUserInfoVo userInfoVo) {
        boolean isNotComplete = userInfoVo.getIsComplete() == 0;
        BasicDBObject object = new BasicDBObject("$set", mongoConverter.convertToMongoType(userInfoVo));
        Document doc = mongoTemplate.getCollection(AdamUserInfoVo.class.getSimpleName()).findOneAndUpdate(
                Query.query(Criteria.where("uid").is(userInfoVo.getUid())).getQueryObject(),
                object, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
        );

        List<Object> paramList = Arrays.asList(
                userInfoVo.getNickName(),
                userInfoVo.getSex(),
                userInfoVo.getBirthday(),
                userInfoVo.getArea(),
                userInfoVo.getSignature(),
                userInfoVo.getAvatar(),
                userInfoVo.getBackground(),
                // TODO: 2021/5/14 用户身份二维码
                null, null,// qr_code, qr_pic
                userInfoVo.getTagMe(),
                userInfoVo.getUid()
        );
        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
                SqlMapping.get(isNotComplete ? "adam_user_info.add" : "adam_user_info.edit", paramList.toArray()));

        redisUtil.hset(AdamRedisConst.INFO_USER, userInfoVo.getUid(), userInfoVo);
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void editMobile(String uid, String mobile) {
        AdamUserInfoVo updateInfoVo = AdamUserInfoVo.getNew();
        updateInfoVo.setMobile(mobile);
        BasicDBObject object = new BasicDBObject("$set", mongoConverter.convertToMongoType(updateInfoVo));
        Document doc = mongoTemplate.getCollection(AdamUserInfoVo.class.getSimpleName()).findOneAndUpdate(
                Query.query(Criteria.where("uid").is(uid)).getQueryObject(),
                object, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.BEFORE)
        );

        AdamUserInfoVo beforeUserInfoVo = BsonUtil.toBean(doc, AdamUserInfoVo.class);
        redisUtil.hdel(AdamRedisConst.INFO_IDENTITY_MOBILE, beforeUserInfoVo.getMobile());
        redisUtil.hset(AdamRedisConst.INFO_IDENTITY_MOBILE, beforeUserInfoVo.getMobile(), uid);
        beforeUserInfoVo.setMobile(mobile);
        redisUtil.hset(AdamRedisConst.INFO_USER, uid, beforeUserInfoVo);
    }
}
