package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "AdamMemberOrderParam", description = "购买会员入参")
@Data
public class AdamMemberOrderParam implements Serializable {
    private static final long serialVersionUID = -2605176979349053352L;
    @ApiModelProperty(position = 10, required = true, value = "会员ID[50]")
    @NotBlank
    private String memberId;
    @ApiModelProperty(position = 11, required = true, value = "购买方式:0-购买会员,1-购买会员码", allowableValues = "0,1")
    @NotNull
    @Min(0)
    @Max(1)
    private Integer mode;
    @ApiModelProperty(position = 12, required = true, value = "应付金额", example = "0.01")
    @DecimalMin("0.01")
    private BigDecimal price;
    @ApiModelProperty(position = 13, required = true, value = "实付金额", example = "0.01")
    @DecimalMin("0.01")
    private BigDecimal pricePaid;
    @ApiModelProperty(position = 14, required = true, value = "会员价格ID")
    @NotBlank
    private String memberPriceId;
    @ApiModelProperty(position = 15, required = true, value = "支付终端", allowableValues = "app,wap,js,applet")
    @NotBlank
    private String deviceFrom;
    @ApiModelProperty(position = 16, required = true, value = "支付方式", allowableValues = "alipay,wepay")
    @NotBlank
    private String payType;
    @ApiModelProperty(position = 17, required = false, value = "苹果支付使用")
    private String productId;
    @ApiModelProperty(position = 18, required = false, value = "姓名", example = "王武")
    private String name;
    @ApiModelProperty(position = 19, required = false, value = "身份证件号", example = "111111111111111111")
    private String idCard;
    @ApiModelProperty(position = 20, required = false, value = "微信支付使用")
    private String authCode;
    @ApiModelProperty(position = 21, required = false, value = "微信支付使用")
    private String openId;
    @ApiModelProperty(position = 22, required = true, value = "未支付/取消支付跳转URL")
    private String showUrl;
    @ApiModelProperty(position = 23, required = true, value = "支付成功跳转URL")
    private String returnUrl;
}
