package com.liquidnet.service.goblin.service.impl.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinOrderLogVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMoneyService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

@Service
public class GoblinStoreMoneyServiceImpl implements IGoblinStoreMoneyService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;

    @Override
    public ResponseDto<HashMap<String,String>> money(String spuId) {
        String uid = CurrentUtil.getCurrentUid();
        GoblinStoreInfoVo vo = redisUtils.getStoreInfoVoByUid(uid);
        if (vo == null) {
            return ResponseDto.failure("店铺不存在");
        }
        String data = mongoUtils.storeMoney(vo.getStoreId(), spuId);
        String[] array = data.split(",");
        HashMap<String,String> map = CollectionUtil.mapStringString();
        map.put("name",array[0]);
        map.put("price",array[1]);
        return ResponseDto.success(map);
    }

    @Override
    public ResponseDto<PageInfo<GoblinOrderLogVo>> getSpuList(String spuName, String st, String et, int page) {
        String uid = CurrentUtil.getCurrentUid();
        GoblinStoreInfoVo vo = redisUtils.getStoreInfoVoByUid(uid);
        if (vo == null) {
            return ResponseDto.failure("店铺不存在");
        }
        HashMap<String, Object> map = mongoUtils.moneyGetSpuList(spuName, st, et, vo.getStoreId(), page);
        PageInfo<GoblinOrderLogVo> info = new PageInfo((List<GoblinOrderLogVo>) map.get("data"));
        info.setTotal((Long) map.get("total"));
        return ResponseDto.success(info);
    }

    @Override
    public ResponseDto<PageInfo<GoblinOrderLogVo>> getOrderOperaList(String spuId, String orderCode, Integer type, String st, String et, int page) {
        HashMap<String, Object> map = mongoUtils.moneyGetSpuDetails(spuId, orderCode, type, st, et, page);
        PageInfo<GoblinOrderLogVo> info = new PageInfo((List<GoblinOrderLogVo>) map.get("data"));
        info.setTotal((Long) map.get("total"));
        return ResponseDto.success(info);
    }
}
