package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 商城订单表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinMixReserveVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = " mix预约表生成id")
    private String mid;
    @ApiModelProperty(value = " mixId")
    private String mixId;
    @ApiModelProperty(value = " uid")
    private String uid;
    @ApiModelProperty(value = " 预约人手机号")
    private String phone;
    @ApiModelProperty(value = " 预约时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdDate;

    private static final GoblinMixReserveVo obj = new GoblinMixReserveVo();

    public static GoblinMixReserveVo getNew() {
        try {
            return (GoblinMixReserveVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinMixReserveVo();
        }
    }
}
