package com.liquidnet.common.third.zxlnft.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 13.NFT地址绑定接口
 * @class: IdentityBindSubmitReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:30
 */
@Data
public class Nft013IdentityBindSubmitReqDto implements Serializable {
    /**
     * 签名信息sign(用户唯一标识)
     */
    private String signData;
    /**
     * 公钥
     */
    private String pubKey;
    /**
     * 用户唯一标识
     */
    private String userIdentification;
    /**
     * 人脸结果id
     */
    private String faceResultId;

    private static final Nft013IdentityBindSubmitReqDto obj = new Nft013IdentityBindSubmitReqDto();
    private static final long serialVersionUID = 6696219005219751327L;

    public static Nft013IdentityBindSubmitReqDto getNew() {
        try {
            return (Nft013IdentityBindSubmitReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft013IdentityBindSubmitReqDto();
        }
    }
}
