package com.liquidnet.common.third.zxlnft.dto;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 25.平台积分转移
 * @class: PointTransferReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:40
 */
public class Nft025PointTransferReqDto implements Serializable {
    /**
     * 平台的公钥
     */
    private String platformPubKey;
    /**
     * 转出者公钥（可以与平台公钥相同，提前是账户有积分可转）
     */
    private String fromPubKey;
    /**
     * 积分接收者的地址
     */
    private String toAddr;
    /**
     * 积分数量
     */
    private String count;
    /**
     * 请求ID，每个请求需要填唯一的ID，重复请求用相同的ID
     */
    private String operateId;
    /**
     * 转出者的私钥签名，签名对象是(platformPubKey_fromPubKey_toAddr_接口名_count_operateId)  接口名=transfer_point
     */
    private String signature;
    /**
     * 平台方的私钥签名，签名对象和signature对象一致
     */
    private String platformSignature;

    private static final Nft025PointTransferReqDto obj = new Nft025PointTransferReqDto();
    private static final long serialVersionUID = 4496567687064297431L;

    public static Nft025PointTransferReqDto getNew() {
        try {
            return (Nft025PointTransferReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft025PointTransferReqDto();
        }
    }
}
