package com.liquidnet.common.third.zxlnft.dto.nft;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: NftStatusUpdateResultReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:59
 */
@Data
public class Nft051StatusUpdateResultResp implements Serializable {
    /**
     * 标记任务状态，2：任务执行中 7：任务成功 10：任务失败
     */
    private Integer taskStatus;
    /**
     * 失败情况下会有提示信息
     */
    private String taskMsg;
    /**
     * 交易hash
     */
    private String txHash;
    /**
     * 链上交易时间戳
     */
    private Long chainTimestamp;

    private static final Nft051StatusUpdateResultResp obj = new Nft051StatusUpdateResultResp();
    public static Nft051StatusUpdateResultResp getNew() {
        try {
            return (Nft051StatusUpdateResultResp) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft051StatusUpdateResultResp();
        }
    }

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }
}
