package com.liquidnet.service.platform.controller.refund;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.RefundCallbackParam;
import com.liquidnet.service.platform.service.refund.OrderRefundsCallbackServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 退款回掉
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-11 6:10 下午
 */
@Api(tags = "前端-refundCallBack")
@RestController
@RequestMapping("refund")
public class OrderRefundCallbackController {

    @Autowired
    private OrderRefundsCallbackServiceImpl orderRefundsCallbackServiceImpl;

    @PostMapping("callback")
    @ApiOperation("退款回调")
    public String refundCallback(RefundCallbackParam refundCallbackParam) {
        String result = orderRefundsCallbackServiceImpl.refundCallback(refundCallbackParam);
        return result;
    }

    @GetMapping("alipayActiveCallback")
    @ApiOperation("支付宝主动查询退款结果")
    public ResponseDto<String> alipayActiveCallback() {
        return orderRefundsCallbackServiceImpl.alipayActiveCallback();
    }

    @GetMapping("overtimeRefund")
    @ApiOperation("超时支付自动退款")
    public ResponseDto<String> overtimeRefund() {
        return orderRefundsCallbackServiceImpl.overtimeRefund();
    }
}
