package com.liquidnet.client.admin.zhengzai.slime.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeCompaniesAdminService;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeSponsorAppliesAdminService;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeSponsorsAdminService;
import com.liquidnet.client.admin.zhengzai.slime.utils.SlimeMongoUtil;
import com.liquidnet.client.admin.zhengzai.slime.utils.SlimeRedisUtil;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.slime.dto.vo.SlimeCompaniesVo;
import com.liquidnet.service.slime.dto.vo.SlimeSponsorAppliesVo;
import com.liquidnet.service.slime.dto.vo.SlimeSponsorsVo;
import com.liquidnet.service.slime.entity.SlimeCompanies;
import com.liquidnet.service.slime.entity.SlimeSponsorApplies;
import com.liquidnet.service.slime.entity.SlimeSponsors;
import com.liquidnet.service.slime.mapper.SlimeSponsorAppliesMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Service
public class SlimeSponsorAppliesAdminServiceImpl extends ServiceImpl<SlimeSponsorAppliesMapper, SlimeSponsorApplies> implements ISlimeSponsorAppliesAdminService {

    @Autowired
    SlimeRedisUtil slimeRedisUtil;

    @Autowired
    SlimeMongoUtil slimeMongoUtil;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    ISlimeSponsorsAdminService slimeSponsorsAdminService;

    @Autowired
    ISlimeCompaniesAdminService slimeCompaniesAdminService;

    @Override
    public boolean applyApprove(String sponsorApplyId, String auditUid, String auditName) {
        LocalDateTime now = LocalDateTime.now();

        // 主办申请 entity
        LambdaQueryWrapper<SlimeSponsorApplies> sponsorAppliesLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeSponsorApplies.class);
        sponsorAppliesLambdaQueryWrapper.eq(SlimeSponsorApplies::getSponsorApplyId, sponsorApplyId);
        SlimeSponsorApplies sponsorAppliesEntity = getOne(sponsorAppliesLambdaQueryWrapper);
        if (0 != sponsorAppliesEntity.getApplyStatus()) {
            throw new LiquidnetServiceException();
        }

        // 创建逻辑

        // 公司 entity mysql
        SlimeCompanies companiesEntity = null;
        if (!sponsorAppliesEntity.getCompanyName().isEmpty()) {
            companiesEntity = new SlimeCompanies();
            companiesEntity.setCompanyId(IDGenerator.nextSnowId());
            companiesEntity.setName(sponsorAppliesEntity.getCompanyName());
            companiesEntity.setLicenseCode(sponsorAppliesEntity.getLicenseCode());
            companiesEntity.setLicenseImg(sponsorAppliesEntity.getLicenseImg());
            companiesEntity.setLegalName(sponsorAppliesEntity.getLegalName());
            companiesEntity.setLegalIdentity(sponsorAppliesEntity.getLegalIdentity());
            companiesEntity.setLegalIdentityObverse(sponsorAppliesEntity.getLegalIdentityObverse());
            companiesEntity.setLegalIdentityReverse(sponsorAppliesEntity.getLegalIdentityReverse());
            companiesEntity.setCreatedAt(now);
            boolean success = slimeCompaniesAdminService.save(companiesEntity);
            if (!success) {
                throw new LiquidnetServiceException();
            }
        }

        // 主办 entity mysql
        SlimeSponsors sponsorsEntity = new SlimeSponsors();
        sponsorsEntity.setSponsorId(IDGenerator.nextSnowId());
        sponsorsEntity.setIsOnline(1);
        sponsorsEntity.setUid(sponsorAppliesEntity.getUid());
        sponsorsEntity.setName(sponsorAppliesEntity.getName());
        sponsorsEntity.setLogo(sponsorAppliesEntity.getLogo());
        sponsorsEntity.setBackground(sponsorAppliesEntity.getBackground());
        sponsorsEntity.setDescription(sponsorAppliesEntity.getDescription());
        sponsorsEntity.setContactName(sponsorAppliesEntity.getContactName());
        sponsorsEntity.setContactIdentity(sponsorAppliesEntity.getContactIdentity());
        sponsorsEntity.setContactIdentityObverse(sponsorAppliesEntity.getContactIdentityObverse());
        sponsorsEntity.setContactIdentityReverse(sponsorAppliesEntity.getContactIdentityReverse());
        sponsorsEntity.setContactEmail(sponsorAppliesEntity.getContactEmail());
        if (null != companiesEntity) {
            sponsorsEntity.setCompanyId(companiesEntity.getCompanyId());
        } else {
            sponsorsEntity.setCompanyId("");
        }
        sponsorsEntity.setCreatedAt(now);
        boolean success = slimeSponsorsAdminService.save(sponsorsEntity);
        if (!success) {
            throw new LiquidnetServiceException();
        }

        // 主办申请 entity mysql
        sponsorAppliesEntity.setApplyStatus(1);
        sponsorAppliesEntity.setReject("");
        sponsorAppliesEntity.setAuditUid(auditUid);
        sponsorAppliesEntity.setAuditName(auditName);
        sponsorAppliesEntity.setAuditedAt(now);
        sponsorAppliesEntity.setUpdatedAt(now);
        sponsorAppliesEntity.setSponsorId(sponsorsEntity.getSponsorId());
        LambdaUpdateWrapper<SlimeSponsorApplies> sponsorAppliesLambdaUpdateWrapper = Wrappers.lambdaUpdate(SlimeSponsorApplies.class);
        sponsorAppliesLambdaUpdateWrapper.eq(SlimeSponsorApplies::getSponsorApplyId, sponsorAppliesEntity.getSponsorApplyId());
        sponsorAppliesLambdaUpdateWrapper.set(SlimeSponsorApplies::getApplyStatus, sponsorAppliesEntity.getApplyStatus());
        sponsorAppliesLambdaUpdateWrapper.set(SlimeSponsorApplies::getReject, sponsorAppliesEntity.getReject());
        sponsorAppliesLambdaUpdateWrapper.set(SlimeSponsorApplies::getAuditUid, sponsorAppliesEntity.getAuditUid());
        sponsorAppliesLambdaUpdateWrapper.set(SlimeSponsorApplies::getAuditName, sponsorAppliesEntity.getAuditName());
        sponsorAppliesLambdaUpdateWrapper.set(SlimeSponsorApplies::getAuditedAt, sponsorAppliesEntity.getAuditedAt());
        sponsorAppliesLambdaUpdateWrapper.set(SlimeSponsorApplies::getUpdatedAt, sponsorAppliesEntity.getUpdatedAt());
        sponsorAppliesLambdaUpdateWrapper.set(SlimeSponsorApplies::getSponsorId, sponsorAppliesEntity.getSponsorId());
        success = update(sponsorAppliesLambdaUpdateWrapper);
        if (!success) {
            throw new LiquidnetServiceException();
        }

        // 主办 vo
        SlimeSponsorsVo sponsorsVo = SlimeSponsorsVo.getNew();
        sponsorsVo.copy(sponsorsEntity);
        if (null != companiesEntity) {
            // 公司 vo
            SlimeCompaniesVo companiesVo = SlimeCompaniesVo.getNew();
            companiesVo.copy(companiesEntity);

            sponsorsVo.setCompaniesVo(companiesVo);
        }

        // 主办申请 vo
        SlimeSponsorAppliesVo sponsorAppliesVo = SlimeSponsorAppliesVo.getNew();
        sponsorAppliesVo.copy(sponsorAppliesEntity);

        // 主办 sync mongo
        slimeMongoUtil.setSponsorsVoBySponsorId(sponsorsVo.getSponsorId(), sponsorsVo);

        // 主办 sync redis
        slimeRedisUtil.setSponsorsVoBySponsorId(sponsorsVo.getSponsorId(), sponsorsVo);

        // 主办申请 sync mongo
        Query query = Query.query(Criteria.where("sponsorApplyId").is(sponsorAppliesVo.getSponsorApplyId()));
        Update update = Update.update("applyStatus", sponsorAppliesVo.getApplyStatus());
        update.set("reject", sponsorAppliesVo.getReject());
        update.set("auditUid", sponsorAppliesVo.getAuditUid());
        update.set("auditName", sponsorAppliesVo.getAuditName());
        update.set("auditedAt", sponsorAppliesVo.getAuditedAt());
        update.set("updatedAt", sponsorAppliesVo.getUpdatedAt());
        update.set("sponsorId", sponsorAppliesVo.getSponsorId());
        mongoTemplate.updateFirst(query, update, SlimeSponsorAppliesVo.class, SlimeSponsorAppliesVo.class.getSimpleName());

        // 主办申请 sync redis
        List<SlimeSponsorAppliesVo> sponsorAppliesVos = slimeRedisUtil.getSponsorAppliesVosByUid(sponsorAppliesVo.getUid());
        slimeRedisUtil.setSponsorAppliesVoByUid(sponsorAppliesVo.getUid(), sponsorAppliesVos, sponsorAppliesVo);
        
        return true;
    }

    @Override
    public boolean applyReject(String sponsorApplyId, String auditUid, String auditName, String reject) {
        LocalDateTime now = LocalDateTime.now();

        // 主办申请 entity
        LambdaQueryWrapper<SlimeSponsorApplies> sponsorAppliesLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeSponsorApplies.class);
        sponsorAppliesLambdaQueryWrapper.eq(SlimeSponsorApplies::getSponsorApplyId, sponsorApplyId);
        SlimeSponsorApplies sponsorAppliesEntity = getOne(sponsorAppliesLambdaQueryWrapper);
        if (0 != sponsorAppliesEntity.getApplyStatus()) {
            throw new LiquidnetServiceException();
        }

        // 驳回逻辑

        // 主办申请 entity mysql
        sponsorAppliesEntity.setApplyStatus(2);
        sponsorAppliesEntity.setReject(reject);
        sponsorAppliesEntity.setAuditUid(auditUid);
        sponsorAppliesEntity.setAuditName(auditName);
        sponsorAppliesEntity.setAuditedAt(now);
        sponsorAppliesEntity.setUpdatedAt(now);
        LambdaUpdateWrapper<SlimeSponsorApplies> sponsorAppliesLambdaUpdateWrapper = Wrappers.lambdaUpdate(SlimeSponsorApplies.class);
        sponsorAppliesLambdaUpdateWrapper.eq(SlimeSponsorApplies::getSponsorApplyId, sponsorAppliesEntity.getSponsorApplyId());
        sponsorAppliesLambdaUpdateWrapper.set(SlimeSponsorApplies::getApplyStatus, sponsorAppliesEntity.getApplyStatus());
        sponsorAppliesLambdaUpdateWrapper.set(SlimeSponsorApplies::getReject, sponsorAppliesEntity.getReject());
        sponsorAppliesLambdaUpdateWrapper.set(SlimeSponsorApplies::getAuditUid, sponsorAppliesEntity.getAuditUid());
        sponsorAppliesLambdaUpdateWrapper.set(SlimeSponsorApplies::getAuditName, sponsorAppliesEntity.getAuditName());
        sponsorAppliesLambdaUpdateWrapper.set(SlimeSponsorApplies::getAuditedAt, sponsorAppliesEntity.getAuditedAt());
        sponsorAppliesLambdaUpdateWrapper.set(SlimeSponsorApplies::getUpdatedAt, sponsorAppliesEntity.getUpdatedAt());
        boolean success = update(sponsorAppliesLambdaUpdateWrapper);
        if (!success) {
            throw new LiquidnetServiceException();
        }

        // 主办申请 vo
        SlimeSponsorAppliesVo sponsorAppliesVo = SlimeSponsorAppliesVo.getNew();
        sponsorAppliesVo.copy(sponsorAppliesEntity);

        // 主办申请 sync mongo
        Query query = Query.query(Criteria.where("sponsorApplyId").is(sponsorAppliesVo.getSponsorApplyId()));
        Update update = Update.update("applyStatus", sponsorAppliesVo.getApplyStatus());
        update.set("reject", sponsorAppliesVo.getReject());
        update.set("auditUid", sponsorAppliesVo.getAuditUid());
        update.set("auditName", sponsorAppliesVo.getAuditName());
        update.set("auditedAt", sponsorAppliesVo.getAuditedAt());
        update.set("updatedAt", sponsorAppliesVo.getUpdatedAt());
        update.set("sponsorId", sponsorAppliesVo.getSponsorId());
        mongoTemplate.updateFirst(query, update, SlimeSponsorAppliesVo.class, SlimeSponsorAppliesVo.class.getSimpleName());

        // 主办申请 sync redis
        List<SlimeSponsorAppliesVo> sponsorAppliesVos = slimeRedisUtil.getSponsorAppliesVosByUid(sponsorAppliesVo.getUid());
        slimeRedisUtil.setSponsorAppliesVoByUid(sponsorAppliesVo.getUid(), sponsorAppliesVos, sponsorAppliesVo);

        return true;
    }
}
