package com.liquidnet.service.adam.service.impl;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.adam.dto.vo.AdamDisposedBaseVo;
import com.liquidnet.service.adam.dto.vo.AdamDisposedUserVo;
import com.liquidnet.service.adam.dto.vo.AdamDisposedVo;
import com.liquidnet.service.adam.service.AdamRdmService;
import com.liquidnet.service.adam.service.IAdamDisposedService;
import com.liquidnet.service.adam.util.ObjectUtil;
import com.liquidnet.service.adam.util.QueueUtils;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.LinkedList;

/**
 * <p>
 * 想去 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-18
 */
@Slf4j
@Service
public class AdamDisposedServiceImpl implements IAdamDisposedService {
//    @Autowired
//    MongoTemplate mongoTemplate;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    AdamRdmService adamRdmService;


    /* ---------------- 外部服务API ---------------- */
//    @Autowired
//    FeignKylinPerformanceClient kylinPerformanceClient;

    @Override
    public void add(AdamDisposedBaseVo vo) {
        LocalDateTime now = LocalDateTime.now();

        vo.setState(1);
        vo.setCreatedAt(now);

//        mongoTemplate.insert(vo, AdamDisposedBaseVo.class.getSimpleName());

        queueUtils.sendMsgByRedis(
                MQConst.AdamQueue.SQL_UCENTER.getKey(),
                SqlMapping.get("adam_disposed.add",
                        vo.getUid(), vo.getContentId(), vo.getType(), vo.getState(), now
                )
        );
    }

    @Override
    public boolean exists(String uid, String type, String contentId) {
        return false;
//        return mongoTemplate.exists(
//                Query.query(Criteria.where("uid").is(uid).and("contentId").is(contentId).and("type").is(type).and("state").is(1)),
//                AdamDisposedBaseVo.class.getSimpleName()
//        );
    }

    @Override
    public void del(String uid, String type, String... contentIds) {
        LocalDateTime now = LocalDateTime.now();

//        DeleteResult deleteResult = mongoTemplate.remove(
//                Query.query(Criteria.where("uid").is(uid).and("type").is(type).and("contentId").in(contentIds)),
//                AdamDisposedBaseVo.class.getSimpleName()
//        );
//        if (deleteResult.getDeletedCount() > 0) {
            LinkedList<Object[]> toMqObjs = CollectionUtil.linkedListObjectArr();
            for (String c : contentIds) {
                toMqObjs.add(new Object[]{now, uid, c});
            }
            queueUtils.sendMsgByRedis(
                    MQConst.AdamQueue.SQL_UCENTER.getKey(),
                    SqlMapping.get("adam_disposed.del", toMqObjs)
            );
//        }
    }

    @Override
    public boolean queryState(String uid, String type, String contentId) {
        return false;
//        return mongoTemplate.exists(
//                Query.query(Criteria.where("uid").is(uid).and("contentId").is(contentId).and("type").is(type).and("state").is(1)),
//                AdamDisposedBaseVo.class.getSimpleName()
//        );
    }

    @Override
    public PagedResult<AdamDisposedVo> queryPage(String uid, String type, int pageNo, int pageSize) {
//        Query query = Query.query(Criteria.where("uid").is(uid).and("type").is(type).and("state").is(1));
//
//        long s = System.currentTimeMillis();
//        long count = mongoTemplate.count(query, AdamDisposedBaseVo.class.getSimpleName());
//        log.debug("#MDB耗时:{}ms", System.currentTimeMillis() - s);
//
//        PagedResult<AdamDisposedVo> pagedResult = ObjectUtil.getAdamDisposedVoPagedResult();
//        if (count > 0) {
//            query.with(PageRequest.of(pageNo - 1, pageSize, Sort.by(Sort.Direction.DESC, "createdAt")));
//
//            s = System.currentTimeMillis();
//            List<AdamDisposedVo> disposedVoList = mongoTemplate.find(query, AdamDisposedVo.class, AdamDisposedBaseVo.class.getSimpleName());
//            log.debug("#MDB耗时:{}ms", System.currentTimeMillis() - s);
//
//            if (!CollectionUtils.isEmpty(disposedVoList)) {
////                List<KylinPerformanceVo> kylinPerformanceVoList = null;
////                try {
////                    String[] contentIds = disposedVoList.stream().map(AdamDisposedVo::getContentId).toArray(a -> new String[disposedVoList.size()]);
////
////                    ResponseDto<List<KylinPerformanceVo>> performanceVoListDto = kylinPerformanceClient.performanceList(contentIds);
////
////                    if (performanceVoListDto.isSuccess()) {
////                        kylinPerformanceVoList = performanceVoListDto.getData();
////                    } else {
////                        log.info("Failed:{}.API.performanceList(...) for AdamDisposedVo:{}", kylinPerformanceClient.getClass().getSimpleName(), performanceVoListDto.toJson());
////                    }
////                } catch (Exception e) {
////                    log.error("Exception:{}.API.performanceList(...) for AdamDisposedVo >> {}", kylinPerformanceClient.getClass().getSimpleName(), e.getLocalizedMessage());
////                }
////
////                if (!CollectionUtils.isEmpty(kylinPerformanceVoList)) {
////                    kylinPerformanceVoList.forEach(pv -> {
////                        disposedVoList.forEach(v -> {
////                            if (pv.getPerformancesId().equals(v.getContentId())) {
////                                AdamCollectInfoVo collectInfoVo = AdamCollectInfoVo.getNew();
////                                BeanUtils.copyProperties(pv, collectInfoVo);
////                                v.setContentInfo(collectInfoVo);
////                            }
////
////                            PageInfo<AdamDisposedUserVo> disposedUserVoPageInfo = this.queryDisposedUsers(type, v.getContentId(), 1, 3);
////
////                            if (disposedUserVoPageInfo.getTotal() > 0) v.setUserVos(disposedUserVoPageInfo.getList());
////                        });
////                    });
////                } else {
////                    disposedVoList.forEach(v -> {
////                        PageInfo<AdamDisposedUserVo> disposedUserVoPageInfo = this.queryDisposedUsers(type, v.getContentId(), 1, 3);
////
////                        if (disposedUserVoPageInfo.getTotal() > 0) v.setUserVos(disposedUserVoPageInfo.getList());
////                    });
////                }
//                s = System.currentTimeMillis();
//                disposedVoList.forEach(r -> {
//                    AdamCollectInfoVo vo = AdamCollectInfoVo.getNew();
//                    KylinPerformanceVo performanceVo = adamRdmService.kylinPerformanceVo(r.getContentId());
//                    if (null != performanceVo) {
////                        BeanUtils.copyProperties(performanceVo, vo);
//                        vo.setPerformancesId(performanceVo.getPerformancesId());
//                        vo.setTitle(performanceVo.getTitle());
//                        vo.setImgPoster(performanceVo.getImgPoster());
//                        vo.setType(performanceVo.getType());
//                        vo.setTimeStart(performanceVo.getTimeStart());
//                        vo.setPrice(performanceVo.getPrice());
//                        vo.setCityName(performanceVo.getCityName());
//                        vo.setFieldName(performanceVo.getFieldName());
//                        vo.setIsMember(performanceVo.getIsMember());
//                        vo.setIsExclusive(performanceVo.getIsExclusive());
//                        vo.setIsDiscount(performanceVo.getIsDiscount());
//                        vo.setIsAdvance(performanceVo.getIsAdvance());
//                    }
//                    r.setContentInfo(vo);
//                    PagedResult<AdamDisposedUserVo> disposedUserVoPagedResult = this.queryDisposedUsers(type, r.getContentId(), 1, 3);
//                    if (disposedUserVoPagedResult.getTotal() > 0) r.setUserVos(disposedUserVoPagedResult.getList());
//                });
//                log.debug("#DIS.RDS.MDB.K耗时:{}ms", System.currentTimeMillis() - s);
//            }
//
//            pagedResult.setList(disposedVoList).setTotal(count, pageSize);
//        }
//
//        return pagedResult;
        return ObjectUtil.getAdamDisposedVoPagedResult();
    }

    @Override
    public PagedResult<AdamDisposedUserVo> queryDisposedUsers(String type, String contentId, int pageNo, int pageSize) {
//        Query query = Query.query(Criteria.where("type").is(type).and("contentId").is(contentId).and("state").is(1));
//
//        long s = System.currentTimeMillis();
//        long count = mongoTemplate.count(query, AdamDisposedBaseVo.class.getSimpleName());
//        log.debug("#MDB耗时:{}ms", System.currentTimeMillis() - s);
//
//        PagedResult<AdamDisposedUserVo> pagedResult = ObjectUtil.getAdamDisposedUserVoPagedResult();
//        if (count > 0) {
//            query.with(PageRequest.of(pageNo - 1, pageSize, Sort.by(Sort.Direction.DESC, "createdAt")));
//
//            s = System.currentTimeMillis();
//            List<AdamDisposedUserVo> disposedUserVoList = mongoTemplate.find(query, AdamDisposedUserVo.class, AdamDisposedBaseVo.class.getSimpleName());
//            log.debug("#MDB耗时:{}ms", System.currentTimeMillis() - s);
//
//            pagedResult.setList(disposedUserVoList).setTotal(count, pageSize);
//        }
//        return pagedResult;
        return ObjectUtil.getAdamDisposedUserVoPagedResult();
    }
}
