package com.liquidnet.service.sweet.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.liquidnet.service.sweet.entity.SweetArtistsUrl;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 艺人表
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetArtistsVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * artists_id
     */
    private String artistsId;


    /**
     * 艺人名称
     */
    private String name;

    private String picUrl;

    /**
     * 拼音
     */
    private String pinyin;

    /**
     * 艺人简介
     */
    private String describes;

    /**
     * 状态 1可用 0不可用
     */
    private Integer status;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatdAt;

    private List<SweetArtistsUrl> sweetArtistsUrl;

    private static final SweetArtistsVo obj = new SweetArtistsVo();

    public static SweetArtistsVo getNew() {
        try {
            return (SweetArtistsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetArtistsVo();
        }
    }
}
