package com.liquidnet.service.adam.dto.admin;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class AdamMemberCodeGenParam implements Serializable {
    private static final long serialVersionUID = 7212595876649709617L;
    @NotBlank(message = "会员类型ID不能为空")
    private String memberId;
    @NotBlank(message = "会员价格ID不能为空")
    private String memberPriceId;
    @NotNull(message = "生成数量不能为空")
    @Min(1)
    @Max(100)
    private Integer genNum;
    @NotBlank(message = "备注描述不能为空")
    private String detail;
}
