package com.liquidnet.service.dragon.channel.alipay.strategy.impl;

import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.channel.alipay.biz.AlipayBiz;
import com.liquidnet.service.dragon.channel.alipay.req.AlipayTradePayReq;
import com.liquidnet.service.dragon.channel.alipay.strategy.IAlipayStrategy;
import com.liquidnet.service.dragon.channel.alipay.strategy.annotation.StrategyAlipayHandler;
import com.liquidnet.service.dragon.channel.alipay.util.AlipayUtil;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: AlipayStrategyWapImpl
 * @Package com.liquidnet.service.dragon.channel.alipay.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/10 14:34
 */
@Service
@StrategyAlipayHandler(DragonConstant.DeviceFromEnum.WAP)
public class AlipayStrategyWapImpl  implements IAlipayStrategy {
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Value("${liquidnet.dragon.alipay.gataway-url}")
    private String alipayGatewayUrl;

    @Autowired
    private AlipayBiz alipayBiz;

    @Override
    public ResponseDto<DragonPayBaseRespDto> dragonPay(DragonPayBaseReqDto dragonPayBaseReqDto) {
        AlipayTradePayReq alipayTradePayReq = new AlipayTradePayReq();
        alipayTradePayReq.setProductCode("QUICK_WAP_PAY");
        alipayTradePayReq.setTotalAmount(dragonPayBaseReqDto.getPrice());
        alipayTradePayReq.setSubject(dragonPayBaseReqDto.getName());
        alipayTradePayReq.setBody(dragonPayBaseReqDto.getDetail());
        //dragon中支付编号
        alipayTradePayReq.setOutTradeNo(IDGenerator.payCode());
        alipayTradePayReq.setTimeExpire(dragonPayBaseReqDto.getExpireTime());
        //调用支付
        Map<String, Object> result = AlipayUtil.tradeWapPay(alipayTradePayReq);
        //拼接返回参数
        DragonPayBaseRespDto respDto = new DragonPayBaseRespDto();
        respDto.setCode(alipayTradePayReq.getOutTradeNo());
        respDto.setOrder_code(dragonPayBaseReqDto.getOrderCode());
        DragonPayBaseRespDto.PayData payData = new DragonPayBaseRespDto.PayData();
        payData.setRedirectUrl(alipayGatewayUrl + "?" + result.get("body"));
        respDto.setPayData(payData);
        //支付订单持久化
        alipayBiz.buildPayOrders(dragonPayBaseReqDto,respDto);
        return ResponseDto.success(respDto);
    }
}
