package com.liquidnet.service.dragon.channel.wepay.strategy.impl;

import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.dragon.channel.wepay.strategy.annotation.StrategyWepayHandler;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.utils.PayWepayUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.SortedMap;
import java.util.TreeMap;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: AlipayStrategyWapImpl
 * @Package com.liquidnet.service.dragon.channel.alipay.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/10 14:34
 */
@Slf4j
@Component
@StrategyWepayHandler(DragonConstant.DeviceFromEnum.WAP)
public class WepayStrategyWapImpl extends AbstractWepayStrategy{

    @Override
    SortedMap<String, Object> buildRequestParamMap(DragonPayBaseReqDto dragonPayBaseReqDto) {
        String nonceStr = PayWepayUtils.getInstance().getNonceStr();
        SortedMap<String, Object> parameters = new TreeMap<>();
        parameters.put("mch_id", PayWepayUtils.getInstance().getMerchantId());
        parameters.put("appid", PayWepayUtils.getInstance().getAppId());
        parameters.put("nonce_str", nonceStr);
        parameters.put("spbill_create_ip", dragonPayBaseReqDto.getClientIp());
        parameters.put("total_fee", dragonPayBaseReqDto.getPrice().multiply(BigDecimal.valueOf(100L)).intValue());
        parameters.put("body", dragonPayBaseReqDto.getName());
        parameters.put("detail", dragonPayBaseReqDto.getDetail());
        parameters.put("out_trade_no", IDGenerator.payCode());
        parameters.put("time_expire", "20210908103456");
        parameters.put("notify_url", "https://www.baidu.com");
        parameters.put("trade_type", "MWEB");
        return parameters;
    }

    @Override
    DragonPayBaseRespDto buildResponseDto() {
        return null;
    }

    @Override
    protected String getRequestUrl() {
        return "https://api.mch.weixin.qq.com/pay/unifiedorder";
    }
}
