package com.liquidnet.service.dragon.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.dto.DragonRefundAppDto;
import com.liquidnet.service.dragon.service.IDragonOrderRefundsService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@RestController
@RequestMapping("refund")
public class RefundController {

    @Autowired
    IDragonOrderRefundsService orderRefundsService;

    @PostMapping("preTest")
    @ApiOperation("微信退款")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> checkCanOrder() {
        orderRefundsService.sendRedisQueue();
        return ResponseDto.success();
    }

    @PostMapping("refundAliPay")
    @ApiOperation("支付宝退款")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> refundAliPay() {
        return ResponseDto.success();
    }

    @PostMapping("refundSingle")
    @ApiOperation("单条退款")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<DragonRefundAppDto> refundSingle(@RequestParam(value = "orderCode") @NotNull(message = "订单号不能为空") String orderCode,
                                                        @RequestParam(value = "code") @NotNull(message = "支付单能为空") String code,
                                                        @RequestParam(value = "orderRefundCode") @NotNull(message = "退款单号不能为空") String orderRefundCode,
                                                        @RequestParam(value = "reason") @NotNull(message = "退款原因不能为空") String reason,
                                                        @RequestParam(value = "notifyUrl") @NotNull(message = "回调地址不能为空") String returnUrl,
                                                        @RequestParam(value = "price") @NotNull(message = "价格不能为空") BigDecimal price,
                                                        @RequestParam(value = "paymentType") @NotNull(message = "支付类型不能为空") String paymentType,
                                                        @RequestParam(value = "paymentId") @NotNull(message = "支付订单号不能为空") String paymentId) {
        return orderRefundsService.dragonRefund(orderCode, code, orderRefundCode, reason, returnUrl, price, paymentType, paymentId);
    }
}
