package com.liquidnet.service.chime.biz;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.chime.dto.ChimeJoinUserCountDto;
import com.liquidnet.service.chime.dto.ChimeUserTagDto;
import com.liquidnet.service.chime.dto.PerformanceDto;
import com.liquidnet.service.chime.utils.DataUtils;
import com.liquidnet.service.chime.vo.mongo.ChimeUserTagsMappingVo;
import com.liquidnet.service.feign.kylin.api.FeignKylinForChimeClient;
import com.liquidnet.service.kylin.constant.KylinPerformanceStatusEnum;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ChimeUserBiz
 * @Package com.liquidnet.service.chime.biz
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/11 16:16
 */
@Slf4j
@Component
public class ChimeUserBiz {
    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private FeignKylinForChimeClient feignKylinForChimeClient;
    /**
     * Json转换list
     * @param tags
     * @return
     */
    public List<ChimeUserTagsMappingVo> buildUserTagVoList(String userId,String tags){
        List<ChimeUserTagsMappingVo> userTagList = new ArrayList<>();
        if(StringUtil.isNotEmpty(tags)){
            ObjectMapper mapper = new ObjectMapper();
            try {
                userTagList = mapper.readValue(tags, new TypeReference<List<ChimeUserTagsMappingVo>>() {});
            } catch (JsonProcessingException e) {
                e.printStackTrace();
                log.error("createChimeUserInfo msg:{}",e.getMessage());
                log.error("createChimeUserInfo error : ",e);
                return null;
            }
        }
        //设置用户id
        userTagList.stream().forEach(vo -> vo.setUserId(userId));
        return userTagList;
    }

    /**
     * Json转换list
     * @param tags
     * @return
     */
    public List<ChimeUserTagDto> buildUserTagDtoList(String userId, String tags){
        List<ChimeUserTagsMappingVo> userTagVoList = new ArrayList<>();
        List<ChimeUserTagDto> userTagDtoList = new ArrayList<>();
        if(StringUtil.isNotEmpty(tags)){
            ObjectMapper mapper = new ObjectMapper();
            try {
                userTagVoList = mapper.readValue(tags, new TypeReference<List<ChimeUserTagsMappingVo>>() {});
            } catch (JsonProcessingException e) {
                e.printStackTrace();
                log.error("createChimeUserInfo msg:{}",e.getMessage());
                log.error("createChimeUserInfo error : ",e);
                return null;
            }
        }
        //设置用户id
        userTagVoList.parallelStream().forEach(vo -> {
            ChimeUserTagDto userTagDto = ChimeUserTagDto.getNew();
            vo.setUserId(userId);
            BeanUtil.copy(vo,userTagDto);
            userTagDtoList.add(userTagDto);
        });
        return userTagDtoList;
    }

    /**
     * 演出voList转换为DtoList
     * @param performanceVoList
     * @return
     */
    public List<PerformanceDto> buildPerformanceDtoList(List<KylinPerformanceVo> performanceVoList){
        List<PerformanceDto> performanceDtoList = new ArrayList<>();
        //获取在场用户加入人数和指定头像列表
        if(StringUtil.isEmpty(performanceVoList)){
            return null;
        }
        List<String> performancesIdList = performanceVoList.stream().map(KylinPerformanceVo::getPerformancesId).collect(Collectors.toList());
        //获取在场用户人数统计
        List<ChimeJoinUserCountDto> joinUserCountDtoList =  dataUtils.getJoinUserCountList(performancesIdList);

        for(KylinPerformanceVo performanceVo:performanceVoList){
            PerformanceDto dto = PerformanceDto.getNew();
            dto.setPerformancesId(performanceVo.getPerformancesId());
            dto.setTitle(performanceVo.getTitle());
            dto.setImgPoster(performanceVo.getImgPoster());
            dto.setTimeStart(performanceVo.getTimeStart());
            dto.setTimeEnd(performanceVo.getTimeEnd());
            dto.setCityName(performanceVo.getCityName());
            dto.setFieldName(performanceVo.getFieldName());
            //初始化
            dto.setJoinUserCount(0);
            if(StringUtil.isNotEmpty(joinUserCountDtoList)){
                joinUserCountDtoList.stream().forEach(joinUserCountDto -> {
                    if(joinUserCountDto.getPerformancesId().equalsIgnoreCase(performanceVo.getPerformancesId())){
                        dto.setJoinUserCount(joinUserCountDto.getCount());
                        dto.setAvatarImgList(joinUserCountDto.getAvatarImgList());
                    }
                });
            }
//            else{
//                dto.setJoinUserCount(123);
//                List<String> imgList = new ArrayList<>();
//                imgList.add("https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png");
//                imgList.add("https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png");
//                imgList.add("https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png");
//                imgList.add("https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png");
//                imgList.add("https://img.zhengzai.tv/user/2021/07/27/a4cc2a4e6dcd44d1812dc60e079086b4.png");
//                dto.setAvatarImgList(imgList);
//            }
            performanceDtoList.add(dto);
        }
        return performanceDtoList;
    }

    /**
     * 根据演出id判断是否在场
     * @param performanceId
     * @return
     */
    public boolean userIsOnline(String performanceId){
        boolean isOnline = false;
        if(StringUtil.isNotNull(performanceId)){
            if(performanceId.equalsIgnoreCase("-1")){
                isOnline = true;
            }else{
                //获取演出状态信息
                ResponseDto<KylinPerformanceVo> responseDto = feignKylinForChimeClient.getDetail(performanceId);
                if(responseDto.isSuccess()&&StringUtil.isNotNull(responseDto.getData())){
                    KylinPerformanceVo kylinPerformanceVo = responseDto.getData();
                    if(kylinPerformanceVo.getAppStatus() == KylinPerformanceStatusEnum.PERFORMANCESTATUS6.getIndex()
                            ||kylinPerformanceVo.getAppStatus() == KylinPerformanceStatusEnum.PERFORMANCESTATUS8.getIndex()
                            ||kylinPerformanceVo.getAppStatus() == KylinPerformanceStatusEnum.PERFORMANCESTATUS9.getIndex()){
                        isOnline = true;
                    }
                }
                //根据演出状态判断是否全部清退当前演出在场人数
                if(!isOnline){
                    //把所有当前演出在场人清退，重置为云在场
                    dataUtils.updateUserIsOnline(performanceId);
                }

            }
        }
        return isOnline;
    }
}
