package com.liquidnet.service.candy.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 券适用规则
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CandyCouponRule implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String cruleId;

    private String couponId;

    /**
     * 适用范围[100-全场｜90-演出｜80-商品]
     */
    private Integer useScope;

    /**
     * 适用名称
     */
    private String busiName;

    /**
     * 适用ID
     */
    private String busiId;

    /**
     * 0-INIT,1-NORMAL,2-INVALID
     */
    private Integer state;

    private String comment;


}
