package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * NFT订单表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-03-25
 */
@ApiModel(value = "GoblinNftOrderDetailsVo", description = "NFT订单列表信息")
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftOrderDetailsVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -7411254314501150169L;

    @ApiModelProperty(value = "订单id")
    private String orderId;

    @ApiModelProperty(value = "商品id")
    private String spuId;

    @ApiModelProperty(value = "款式id")
    private String skuId;

    @ApiModelProperty(value = "数量")
    private Integer num;

    @ApiModelProperty(value = "店铺id")
    private String storeId;

    @ApiModelProperty(value = "商铺名称")
    private String storeName;

    @ApiModelProperty(value = "订单号")
    private String orderCode;

    @ApiModelProperty(value = "应付金额")
    private BigDecimal priceTotal;

    @ApiModelProperty(value = "实付金额")
    private BigDecimal priceActual;

    @ApiModelProperty(value = "订单状态 1待付款 2已付款 3未付款取消订单 4退款中 5已退款")
    private Integer status;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "商品信息")
    GoblinNftOrderGoodsSkuInfoVo goodsSkuInfoVo;

    @ApiModelProperty(value = " 混合售id")
    private String mixId;
    @ApiModelProperty(value = " 混合售名称")
    private String mixName;

    @ApiModelProperty(value = "订单藏品信息")
    GoblinNftOrderArtworkInfoVo artworkInfoVo;

    private static final GoblinNftOrderDetailsVo obj = new GoblinNftOrderDetailsVo();

    public static GoblinNftOrderDetailsVo getNew() {
        try {
            return (GoblinNftOrderDetailsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftOrderDetailsVo();
        }
    }

    public GoblinNftOrderDetailsVo copy(GoblinNftOrderVo source) {
        if (null == source) return this;
        this.setOrderId(source.getOrderId());
        this.setSpuId(source.getSpuId());
        this.setSkuId(source.getSkuId());
        this.setNum(source.getNum());
        this.setStoreId(source.getStoreId());
        this.setStoreName(source.getStoreName());
        this.setOrderCode(source.getOrderCode());
        this.setPriceTotal(source.getPriceTotal());
        this.setPriceActual(source.getPriceActual());
        this.setStatus(source.getStatus());
        this.setCreatedAt(source.getCreatedAt());
        this.setMixId(source.getMixId());
        this.setMixName(source.getMixName());
        return this;
    }

}
