package com.liquidnet.service.platform.service.impl.goblin;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExCodeVo;
import com.liquidnet.service.goblin.entity.GoblinGoodsSku;
import com.liquidnet.service.goblin.entity.GoblinNftExCode;
import com.liquidnet.service.goblin.entity.GoblinNftExSku;
import com.liquidnet.service.goblin.mapper.GoblinGoodsSkuMapper;
import com.liquidnet.service.goblin.mapper.GoblinNftExCodeMapper;
import com.liquidnet.service.goblin.mapper.GoblinNftExSkuMapper;
import com.liquidnet.service.goblin.param.GoblinNftExCodeParam;
import com.liquidnet.service.goblin.service.IGoblinNftExCodeService;
import com.liquidnet.service.platform.utils.GoblinRedisUtils;
import com.liquidnet.service.platform.utils.ObjectUtil;
import com.sun.org.apache.xpath.internal.operations.Bool;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: wll
 * @Description:
 * @Date:Create：in 2022/4/20 5:36 下午
 */
@Service
@Slf4j
public class GoblinNftExCodeServiceImpl implements IGoblinNftExCodeService {

    @Autowired
    private GoblinGoodsSkuMapper goblinGoodsSkuMapper;
    @Autowired
    private GoblinNftExCodeMapper goblinNftExCodeMapper;
    @Autowired
    private GoblinNftExSkuMapper goblinNftExSkuMapper;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;

    @Override
    public PageInfo<GoblinNftExCodeVo> selectCodePageList(GoblinNftExCodeParam goblinNftExCodeParam) {

        // 入参
        GoblinNftExCode goblinNftExCode = GoblinNftExCode.getNew();
        goblinNftExCode.setCode(goblinNftExCodeParam.getCode());
        goblinNftExCode.setActivityId(goblinNftExCodeParam.getActivityId());
        goblinNftExCode.setState(goblinNftExCodeParam.getState());
        goblinNftExCode.setRedeemUid(goblinNftExCodeParam.getUserId());
        goblinNftExCode.setIsDrivi(goblinNftExCodeParam.getIsDrivi());
        if (StringUtil.isNotBlank(goblinNftExCodeParam.getSkuName())){
            // 根据藏品名称获取 skuIds
            String skuName = goblinNftExCodeParam.getSkuName();
            List<GoblinGoodsSku> goblinGoodsSkus = goblinGoodsSkuMapper.selectSkuLikeName(skuName);
            if (goblinGoodsSkus.size() <= 0){
                return new PageInfo<>();
            }
            StringBuffer skuIds = new StringBuffer();
            for (GoblinGoodsSku goblinGoodsSku:goblinGoodsSkus) {
                skuIds.append(goblinGoodsSku.getSkuId()).append(",");
            }
            goblinNftExCode.setSkuId(skuIds.deleteCharAt(skuIds.length()-1).toString());
        }


        PageHelper.startPage(goblinNftExCodeParam.getPageNum(),20,true);
        List<GoblinNftExCode> goblinNftExCodes = goblinNftExCodeMapper.selectGoblinNftCode(goblinNftExCode);
        StringBuffer skuIds = new StringBuffer();
        StringBuffer acticityIds = new StringBuffer();
        for (GoblinNftExCode gnc: goblinNftExCodes) {
            skuIds.append(gnc.getSkuId()).append(",");
            acticityIds.append(gnc.getActivityId()).append(",");
        }

        // 批量查询
        List<GoblinGoodsSku> goblinNftExCodeList =  goblinGoodsSkuMapper.selectByIds(skuIds.toString());


        // 获取对象实例
        ArrayList<GoblinNftExCodeVo> goblinNftExCodeArrayList = ObjectUtil.getGoblinNftExCodeArrayList();
        for (GoblinNftExCode gnc: goblinNftExCodes) {
            for (GoblinGoodsSku goblinGoodsSku: goblinNftExCodeList) {
                if (gnc.getSkuId().equals(goblinGoodsSku.getSkuId())){
                    GoblinNftExCodeVo goblinNftExCodeVo = GoblinNftExCodeVo.getNew().copy(gnc);
                    goblinNftExCodeVo.setSkuName(goblinGoodsSku.getName());
                    goblinNftExCodeArrayList.add(goblinNftExCodeVo);
                    break;
                }
            }
        }

        // 根据活动ids 获取兑换活动和sku的关联
        List<GoblinNftExSku> goblinNftExSkus = goblinNftExSkuMapper.selectGoblinNftExSkuByActivityIds(acticityIds.toString());

        Map<String,List<GoblinNftExSku>> map = new HashMap<>();
        for (GoblinNftExSku goblinNftExSku: goblinNftExSkus) {
            if (map.get(goblinNftExSku.getActivityId()) == null){
                map.put(goblinNftExSku.getActivityId(),new ArrayList<>());
            }
            map.get(goblinNftExSku.getActivityId()).add(goblinNftExSku);
        }




        for (GoblinNftExCodeVo gnc: goblinNftExCodeArrayList) {
            List<GoblinNftExSku> goblinNftExSkuList = map.get(gnc.getActivityId());
            for (GoblinNftExSku goblinNftExSku: goblinNftExSkuList) {
                if (gnc.getSkuId().equals(goblinNftExSku.getSkuId())){
                    gnc.setExStartTime(goblinNftExSku.getExStartTime());
                    gnc.setExStopTime(goblinNftExSku.getExStopTime());
                    break;
                }
            }
        }
        


        PageInfo<GoblinNftExCodeVo> pageInfo = new PageInfo<>(goblinNftExCodeArrayList);

        return pageInfo;
    }

    @Override
    public Boolean defDrivLoseCode(String codeIds) {

        LocalDateTime now = LocalDateTime.now();

        // 获取兑换码
        List<GoblinNftExCode> goblinNftExCodes = goblinNftExCodeMapper.selectByIds(codeIds);

        List<String> codes = new ArrayList<>();
        for (GoblinNftExCode goblinNftExCode: goblinNftExCodes) {
            // redis 主动失效
            codes.add(goblinNftExCode.getCode());
            goblinNftExCode.setState(3);
            goblinNftExCode.setUpdatedAt(now);
        }
        goblinRedisUtils.removeCodes(codes);
        // 批量修改
        goblinNftExCodeMapper.updateCodes(goblinNftExCodes);

        return true;
    }


}
