package com.liquidnet.service.adam.dto.rsc;

import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamChimeUinfoResp", description = "社交用户信息查询响应")
@Data
public class AdamChimeUinfoDto implements Serializable, Cloneable {
    private static final long serialVersionUID = -2948770525358677081L;
    @ApiModelProperty(position = 1, value = "用户ID[64]")
    private String userId;
    @ApiModelProperty(position = 2, value = "用户昵称")
    private String nickName;
    @ApiModelProperty(position = 3, value = "头像")
    private String avatar;
    @ApiModelProperty(position = 4, value = "封面")
    private String userCover;
    @ApiModelProperty(position = 5, value = "生日")
    private String birthday;
    @ApiModelProperty(position = 6, value = "签名")
    private String signature;
    @ApiModelProperty(position = 7, value = "常住地/区域～ 已废除，参见[province、city、county]")
    private String area;
    @ApiModelProperty(position = 8, value = "常住地/省 ～ 替换原字段[area]")
    private String province;
    @ApiModelProperty(position = 9, value = "常住地/市 ～ 替换原字段[area]")
    private String city;
    @ApiModelProperty(position = 10, value = "常住地/区县 ～ 替换原字段[area]")
    private String county;

    private static final AdamChimeUinfoDto obj = new AdamChimeUinfoDto();

    public static AdamChimeUinfoDto getNew() {
        try {
            return (AdamChimeUinfoDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamChimeUinfoDto();
    }

    public AdamChimeUinfoDto copy(AdamUserInfoVo source) {
        if (null == source) return this;
        this.setUserId(source.getUid());
        this.setNickName(source.getNickname());
        this.setAvatar(source.getAvatar());
        this.setUserCover(source.getBackground());
        this.setBirthday(source.getBirthday());
        this.setSignature(source.getSignature());
        this.setArea(source.getArea());
        //
        this.setProvince(source.getProvince());
        this.setCity(source.getCity());
        this.setCounty(source.getCounty());
        return this;
    }
}
