package com.liquidnet.service.goblin.dto.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.entity.GoblinOrderAttr;
import com.liquidnet.service.goblin.entity.GoblinOrderSku;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * <p>
 * 商城订单属性表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinOrderAttrVo implements Serializable, Cloneable {
    @ApiModelProperty(value = " 主键id")
    private String orderAttrId;
    @ApiModelProperty(value = " 订单id")
    private String orderId;
    @ApiModelProperty(value = " 收货人")
    private String expressContacts;
    @ApiModelProperty(value = " 收货地址[省市区]")
    private String expressAddress;
    @ApiModelProperty(value = " 收货地址[详细]")
    private String expressAddressDetail;
    @ApiModelProperty(value = " 收货人联系方式")
    private String expressPhone;
    @ApiModelProperty(value = " 快递方式 [1寄付|2到付|3-包邮]")
    private Integer expressType;
    @ApiModelProperty(value = " 订单的赠品信息格式为JSON")
    private String giftInfos;
    @ApiModelProperty(value = " 创建时间")
    private String createdAt;

    public GoblinOrderAttrVo copy(GoblinOrderAttr source) {
        if (null == source) return this;
        this.setOrderAttrId(source.getOrderAttrId());
        this.setOrderId(source.getOrderId());
        this.setExpressContacts(source.getExpressContacts());
        this.setExpressAddress(source.getExpressAddress());
        this.setExpressAddressDetail(source.getExpressAddressDetail());
        this.setExpressPhone(source.getExpressPhone());
        this.setExpressType(source.getExpressType());
        this.setGiftInfos(source.getGiftInfos());
        if(source.getCreatedAt()!=null) {
            this.setCreatedAt(source.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        }
        return this;
    }

    private static final GoblinOrderAttrVo obj = new GoblinOrderAttrVo();

    public static GoblinOrderAttrVo getNew() {
        try {
            return (GoblinOrderAttrVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinOrderAttrVo();
        }
    }
}
