package com.liquidnet.service.feign.slime.api;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.slime.dto.vo.SlimeFieldsDetailsVo;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "liquidnet-service-slime",
        contextId = "FeignSlimeApiClient", path = "slime",
        url = "${liquidnet.service.slime.url}",
        fallback = FallbackFactory.Default.class)
public interface FeignSlimeApiClient {

    @GetMapping("fields/app/details")
    ResponseDto<SlimeFieldsDetailsVo> fieldDetails(@RequestParam("fieldId") String fieldId);
}
