package com.liquidnet.service.sweet.controller;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetStage;
import com.liquidnet.service.sweet.service.ISweetStageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 舞台表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Api(tags = "舞台")
@RestController
@RequestMapping("/sweet-stage")
public class SweetStageController {

    @Autowired
    ISweetStageService sweetStageService;

    @GetMapping("list")
    @ApiOperation("舞台列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "title", value = "舞台名称", required = false),
    })
    public ResponseDto<PageInfo<SweetStage>> getList(@RequestParam() Integer page,
                                                     @RequestParam() Integer size,
                                                     @RequestParam(required = false) String title) {
        return sweetStageService.getList(page, size, title);
    }

    @PostMapping("add")
    @ApiOperation("添加舞台")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "title", value = "舞台名", required = true),
    })
    public ResponseDto<Boolean> add(@RequestParam() String title) {
        return sweetStageService.add(title);
    }

    @GetMapping("detail")
    @ApiOperation("舞台详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "stageId", value = "舞台Id", required = true),
    })
    public ResponseDto<SweetStage> detail(@RequestParam() String stageId) {
        return sweetStageService.detail(stageId);
    }

    @PostMapping("change")
    @ApiOperation("修改舞台")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "stageId", value = "舞台Id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "title", value = "舞台名", required = true),
    })
    public ResponseDto<Boolean> change(@RequestParam() String stageId,
                                       @RequestParam() String title) {
        return sweetStageService.change(title, stageId);
    }
}
