package com.liquidnet.service.platform.service.express.shunfeng;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.param.*;
import com.liquidnet.service.kylin.dto.vo.express.KylinOrderExpressRouteVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.IKylinOrderExpress;
import com.liquidnet.service.platform.utils.ShunfengSignUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 演出 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Service
@Slf4j
public class PerformancesExpressCallbackServiceImpl extends ServiceImpl<KylinOrderExpressMapper, KylinOrderExpress> implements IKylinOrderExpress {

    @Value("${liquidnet.shunfeng.custid}")
    private String custid;
    @Value("${liquidnet.shunfeng.jCompany}")
    private String jCompany;
    @Value("${liquidnet.shunfeng.jContact}")
    private String jContact;
    @Value("${liquidnet.shunfeng.jTel}")
    private String jTel;
    @Value("${liquidnet.shunfeng.jProvince}")
    private String jProvince;
    @Value("${liquidnet.shunfeng.jCity}")
    private String jCity;
    @Value("${liquidnet.shunfeng.jAddress}")
    private String jAddress;
    @Value("${liquidnet.shunfeng.expressType}")
    private Integer expressType;
    @Value("${liquidnet.shunfeng.depositumInfo}")
    private String depositumInfo;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private ShunfengSignUtils shunfengSignUtils;

    @Autowired
    private KylinOrderExpressMapper kylinOrderExpressMapper;

    @Autowired
    private KylinOrderExpressFeeInfoMapper kylinOrderExpressFeeInfoMapper;

    @Autowired
    private KylinOrderExpressRouteMapper kylinOrderExpressRouteMapper;

    @Autowired
    private KylinOrderExpressStatusMapper kylinOrderExpressStatusMapper;

    @Autowired
    HttpServletRequest httpServletRequest;

    @Autowired
    private RedisUtil redisUtil;

    public boolean orderStatus(@RequestBody String params) {
        boolean res = shunfengSignUtils.receiveRequestAndCheckSign(params, httpServletRequest);
        if (res) {
            PerformanceExpressPushStatusParam performanceExpressPushStatusParam = JsonUtils.fromJson(params, PerformanceExpressPushStatusParam.class);
            KylinOrderExpressStatus kylinOrderExpressStatus = new KylinOrderExpressStatus();
            String orderExpressStatusId = IDGenerator.nextSnowId();

            KylinOrderExpress orderExpressInfo = kylinOrderExpressMapper.selectOne(new QueryWrapper<KylinOrderExpress>().eq("mailno", performanceExpressPushStatusParam.getWaybillNo()));
            kylinOrderExpressStatus.setOrderExpressStatusId(orderExpressStatusId);
            kylinOrderExpressStatus.setOrderExpressId(orderExpressInfo.getOrderExpressId());
            kylinOrderExpressStatus.setOrderStateCode(performanceExpressPushStatusParam.getOrderStateCode());
            kylinOrderExpressStatus.setOrderStateDesc(performanceExpressPushStatusParam.getOrderStateDesc());
            kylinOrderExpressStatus.setEmpCode(performanceExpressPushStatusParam.getEmpCode());
            kylinOrderExpressStatus.setEmpPhone(performanceExpressPushStatusParam.getEmpPhone());
            kylinOrderExpressStatus.setNetCode(performanceExpressPushStatusParam.getNetCode());
            kylinOrderExpressStatus.setLastTime(performanceExpressPushStatusParam.getLastTime());
            kylinOrderExpressStatus.setBookTime(performanceExpressPushStatusParam.getBookTime());
            kylinOrderExpressStatus.setCarrierCode(performanceExpressPushStatusParam.getCarrierCode());
            kylinOrderExpressStatus.setCreatedAt(DateUtil.getNowTime());
            kylinOrderExpressStatusMapper.insert(kylinOrderExpressStatus);
            return true;
        }

        return false;
    }

    public boolean orderFreightList(@RequestBody String params) {
        boolean res = shunfengSignUtils.receiveRequestAndCheckSign(params, httpServletRequest);
        if (true) {
            PerformanceExpressPushFreightParam performanceExpressPushFreightParam = JsonUtils.fromJson(params, PerformanceExpressPushFreightParam.class);
            KylinOrderExpress orderExpressInfo = kylinOrderExpressMapper.selectOne(new QueryWrapper<KylinOrderExpress>().eq("mailno", performanceExpressPushFreightParam.getWaybillNo()));
            String orderExpressId = orderExpressInfo.getOrderExpressId();

            kylinOrderExpressFeeInfoMapper.delete(new QueryWrapper<KylinOrderExpressFeeInfo>().eq("order_express_id", orderExpressId));

            List<PerformanceExpressPushFreightInfoParam> feeList = performanceExpressPushFreightParam.getFeeList();
            for (PerformanceExpressPushFreightInfoParam feeInfo : feeList) {
                KylinOrderExpressFeeInfo kylinOrderExpressFeeInfo = new KylinOrderExpressFeeInfo();
                String orderExpressFeeInfoId = IDGenerator.nextSnowId();
                kylinOrderExpressFeeInfo.setOrderExpressFeeInfoId(orderExpressFeeInfoId);
                kylinOrderExpressFeeInfo.setOrderExpressId(orderExpressId);
                kylinOrderExpressFeeInfo.setType(feeInfo.getFeeIndType().toString());
                kylinOrderExpressFeeInfo.setName(feeInfo.getFeeTypeCode());
                kylinOrderExpressFeeInfo.setValue(BigDecimal.valueOf(feeInfo.getFeeAmt()));
                kylinOrderExpressFeeInfo.setCreatedAt(DateUtil.getNowTime());
                kylinOrderExpressFeeInfoMapper.insert(kylinOrderExpressFeeInfo);
            }
            return true;
        }

        return false;
    }

    public boolean orderRoute(@RequestBody String params) {
        boolean res = shunfengSignUtils.receiveRequestAndCheckSign(params, httpServletRequest);
        if (res) {
            PerformanceExpressPushRouteParam performanceExpressPushRouteParam = JsonUtils.fromJson(params, PerformanceExpressPushRouteParam.class);
            KylinOrderExpressRoute kylinOrderExpressRoute = new KylinOrderExpressRoute();
            String orderExpressRouteId = IDGenerator.nextSnowId();

            KylinOrderExpress orderExpressInfo = kylinOrderExpressMapper.selectOne(new QueryWrapper<KylinOrderExpress>().eq("mailno", performanceExpressPushRouteParam.getMailno()));
            kylinOrderExpressRoute.setOrderExpressRouteId(orderExpressRouteId);
            kylinOrderExpressRoute.setOrderExpressId(orderExpressInfo.getOrderExpressId());
            kylinOrderExpressRoute.setAcceptAddress(performanceExpressPushRouteParam.getAcceptAddress());
            kylinOrderExpressRoute.setAcceptTotaltime(performanceExpressPushRouteParam.getAcceptTime());
            kylinOrderExpressRoute.setRemark(performanceExpressPushRouteParam.getRemark());
            kylinOrderExpressRoute.setOpcode(performanceExpressPushRouteParam.getOpCode());
            kylinOrderExpressRoute.setCreatedAt(DateUtil.getNowTime());
            kylinOrderExpressRouteMapper.insert(kylinOrderExpressRoute);
            return true;
        }

        return false;
    }

    public List<KylinOrderExpressRouteVo> orderRouteDetail(String orderTicketsId) {
        String redisKey = KylinRedisConst.ORDER_ROUTE_INFO.concat(orderTicketsId);
        if (!redisUtil.hasKey(redisKey)) {
            Query query = new Query();
            query.addCriteria(Criteria.where("orderTicketsId").is(orderTicketsId));
            List<KylinOrderExpressRouteVo> routeList = mongoTemplate.find(query, KylinOrderExpressRouteVo.class, KylinOrderExpressRouteVo.class.getSimpleName());
            redisUtil.set(redisKey, routeList);
        }
        return (List<KylinOrderExpressRouteVo>) redisUtil.get(redisKey);
    }
}