package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * upush 系统消息
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-15
 */
@ApiModel(value = "KylinPerformanceSubscribeUpushVo", description = "预约出参")
@Data
public class KylinPerformanceSubscribeUpushVo implements Serializable, Cloneable {

    @ApiModelProperty(value = "推送标题")
    private String pushTitle;

    @ApiModelProperty(value = "推送内容")
    private String pushContent;

    @ApiModelProperty(value = "封面图")
    private String img;

    @ApiModelProperty(value = "跳转类型 0打开APP,16演出首页,17商城首页,5场地详情,6票务详情,7商品详情,14商品集合,20音乐人详情,24音乐人集合,21歌曲详情,22专辑详情,26摩登会员,12活动跳转可分享,100活动跳转,32系统消息列表")
    private Integer jumpType;

    @ApiModelProperty(value = "跳转值 id或者url或者空 根据type区分")
    private String jumpValue;

    @ApiModelProperty(value = "推送时间")
    private String pushTime;

    @ApiModelProperty(value = "推送类型 0 开票提醒")
    private Integer type;

    @ApiModelProperty(value = "演出开始时间")
    private String timeStart;

    @ApiModelProperty( value = "演出id")
    private String performancesId;

    @ApiModelProperty(value = "场次id")
    private String ticketTimesId;

    @ApiModelProperty(position = 5,value = "票种id")
    private String ticketsId;

}
