package com.liquidnet.service.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.SmileUserVO;
import com.liquidnet.service.goblin.service.manage.SmileFrontService;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.util.ObjectUtil;
import com.liquidnet.service.util.QueueUtils;
import com.liquidnet.service.util.SmileMongoUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@Service
@Slf4j
public class SmileFrontServiceImpl implements SmileFrontService {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SmileMongoUtils smileMongoUtils;
    @Autowired
    QueueUtils queueUtils;
    public boolean saveOrUpdateUser(SmileUserVO smileUserVO,SmileUserVO redisVo,String type){
        //redis里面更新
        if(null==redisVo){
            smileUserVO.setCreatedDate(LocalDateTime.now());
            smileUserVO.setDelTag(0);
            redisUtil.set(SmileRedisConst.SMILE_USER.concat(smileUserVO.getUid()),smileUserVO);
            insertUser(smileUserVO);
            //插入
        }else{
            //update
            setUser(smileUserVO,redisVo,type);
            redisUtil.set(SmileRedisConst.SMILE_USER.concat(redisVo.getUid()),redisVo);
            updateUser(smileUserVO);
        }
        return true;
    }
    public void insertUser(SmileUserVO smileUserVO){
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        sqls.add(SqlMapping.get("smile_service.insert_user"));
        LinkedList<Object[]> sqlData = CollectionUtil.linkedListObjectArr();
        sqlData.add(new Object[]{
                smileUserVO.getImg(),smileUserVO.getName(),smileUserVO.getUid(),smileUserVO.getBirthday(),smileUserVO.getSex(),
                smileUserVO.getPhone(),smileUserVO.getProvinceKey(),smileUserVO.getProvince(),smileUserVO.getCityKey(),smileUserVO.getCity(),
                smileUserVO.getAreaKey(),smileUserVO.getArea(),smileUserVO.getAddress(),smileUserVO.getWechat(),smileUserVO.getType(),smileUserVO.getOrgId(),
                smileUserVO.getIdCard(),smileUserVO.getSchoolName(),smileUserVO.getSchoolMajor(),smileUserVO.getIdentity(),smileUserVO.getTag(),smileUserVO.getAgent(),
                smileUserVO.getAuthTag(),smileUserVO.getErrorReason(),smileUserVO.getIntroduce(),smileUserVO.getSpecialty1(),smileUserVO.getSpecialty2(),
                smileUserVO.getSpecialty3(),smileUserVO.getState(),smileUserVO.getDelTag(),smileUserVO.getCreatedDate(),smileUserVO.getUpdatedDate(),smileUserVO.getSchoolId()

        });
        String sqlDatas = SqlMapping.gets(sqls, sqlData);
        queueUtils.sendMsgByRedis(MQConst.SmileQueue.SMILE_USER.getKey(), sqlDatas);
    }
    public void updateUser(SmileUserVO smileUserVO){
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        sqls.add(SqlMapping.get("smile_service.update_user"));
        LinkedList<Object[]> sqlData = CollectionUtil.linkedListObjectArr();
        sqlData.add(new Object[]{
                smileUserVO.getImg(),smileUserVO.getName(),smileUserVO.getUid(),smileUserVO.getBirthday(),smileUserVO.getSex(),
                smileUserVO.getPhone(),smileUserVO.getProvinceKey(),smileUserVO.getProvince(),smileUserVO.getCityKey(),smileUserVO.getCity(),
                smileUserVO.getAreaKey(),smileUserVO.getArea(),smileUserVO.getAddress(),smileUserVO.getWechat(),smileUserVO.getType(),smileUserVO.getOrgId(),
                smileUserVO.getIdCard(),smileUserVO.getSchoolName(),smileUserVO.getSchoolMajor(),smileUserVO.getIdentity(),smileUserVO.getTag(),smileUserVO.getAgent(),
                smileUserVO.getAuthTag(),smileUserVO.getErrorReason(),smileUserVO.getIntroduce(),smileUserVO.getSpecialty1(),smileUserVO.getSpecialty2(),
                smileUserVO.getSpecialty3(),smileUserVO.getState(),smileUserVO.getUpdatedDate(),smileUserVO.getSchoolId()

        });
        String sqlDatas = SqlMapping.gets(sqls, sqlData);
        queueUtils.sendMsgByRedis(MQConst.SmileQueue.SMILE_USER.getKey(), sqlDatas);
    }

    public List<KylinPerformanceVo>  getPerformance(){
        ArrayList<KylinPerformanceVo> list= ObjectUtil.kylinPerformanceVoList();
        String perforManceIds= (String) redisUtil.get(SmileRedisConst.SMILE_SHOW);
        if(StringUtil.isNotBlank(perforManceIds)){
            for(String id:perforManceIds.split(",")){
                KylinPerformanceVo kylinPerformanceVo=smileMongoUtils.getPerFormance(id);
                if(null!=kylinPerformanceVo){
                    list.add(kylinPerformanceVo);
                }
            }
        }
        return list;
    }
    public void setUser(SmileUserVO smileUserVO,SmileUserVO redisVo,String type){
        if(type.equals("1")){
            redisVo.setImg(smileUserVO.getImg());
            redisVo.setSex(smileUserVO.getSex());
            redisVo.setProvinceKey(smileUserVO.getProvinceKey());
            redisVo.setProvince(smileUserVO.getProvince());
            redisVo.setCity(smileUserVO.getCity());
            redisVo.setCityKey(smileUserVO.getCityKey());
            redisVo.setArea(smileUserVO.getArea());
            redisVo.setAreaKey(smileUserVO.getAreaKey());
            redisVo.setAddress(smileUserVO.getAddress());
            redisVo.setWechat(smileUserVO.getWechat());
            redisVo.setSchoolName(smileUserVO.getSchoolName());
            redisVo.setSchoolId(smileUserVO.getSchoolId());
            redisVo.setSchoolMajor(smileUserVO.getSchoolMajor());
            redisVo.setIdentity(smileUserVO.getIdentity());
            redisVo.setTag(smileUserVO.getTag());
            redisVo.setUpdatedDate(LocalDateTime.now());
            redisVo.setUid(smileUserVO.getUid());
            redisVo.setDelTag(0);
        }else if (type.equals("2")){
            redisVo.setName(smileUserVO.getName());
            redisVo.setIdCard(smileUserVO.getIdCard());
            redisVo.setUpdatedDate(LocalDateTime.now());
            redisVo.setUid(smileUserVO.getUid());
            redisVo.setDelTag(0);
        }else if(type.equals("3")){
            redisVo.setIntroduce(smileUserVO.getIntroduce());
            redisVo.setSpecialty1(smileUserVO.getSpecialty1());
            redisVo.setSpecialty2(smileUserVO.getSpecialty2());
            redisVo.setSpecialty3(smileUserVO.getSpecialty2());
            redisVo.setUpdatedDate(LocalDateTime.now());
            redisVo.setUid(smileUserVO.getUid());
            redisVo.setDelTag(0);
        }
    }


}
