package com.liquidnet.common.third.zxlnft.dto.nft;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 34.发行 NFT
 * @class: PublishReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:45
 */
@Data
public class Nft034PublishReq implements Serializable {
    /**
     * 发行人公钥
     */
    private String pubKey;
    /**
     * 平台公钥
     */
    private String platformPubKey;
    /**
     * 作者名，中文+英文(数字或符号为非法输入) 不超过30个字符
     */
    private String author;
    /**
     * nft名字，中英文数字均可，不超过256个字符
     */
    private String name;
    /**
     * 介质url，不超过1024个字符
     */
    private String url;
    /**
     * 预览图url，不超过1024个字符。(至信链浏览器展示预览图尺寸为290*290，请上传比例为1:1的图片)
     */
    private String displayUrl;
    /**
     * nft介质的hash, 长度64个字符(调用sdk的hdsignature.SM3Hash方式，再使用hex.EncodeToString方法生成字符串)
     */
    private String hash;
    /**
     * nft简介，500个字符以内
     */
    private String desc;
    /**
     * 标签，【文创】，游戏，动漫，30个字符以内
     */
    //@Null
    private String flag;
    /**
     * 发行量，如果没有系列，就只能为1，如果有系列从1开始，比如如有100个，系列id范围则为[1-100],单次发行个数不超过1000，
     * 同系列下同介质个数总共不能超过3000
     */
    private Long publishCount;
    /**
     * 系列ID
     */
    //@Null
    private String seriesId;
    /**
     * 系列子ID从多少开始，没有系列只能填1。有系列情况下，根据系列声明时指定
     * seriesBeginFromZero决定是否可以从0开始。总体上不超过系列的最大值，
     * (比如系列如果从1开始，最大值为100。系列ID只能从1-100)
     */
    private Integer seriesBeginIndex;
    /**
     * 1：可售 2：不可售
     */
    private Integer sellStatus;
    /**
     * 可售状态下有意义，表示售卖多少积分
     */
    //@Null
    private Long sellCount;
    /**
     * 请求ID，每个请求需要填唯一的ID，重复请求用相同的ID，为了保证唯一性，必须使用uuid
     */
    private String operateId;
    /**
     * 扩展字段，用户自定义，长度不超过1024个字符
     */
    //@Null
    private String metaData;
    /**
     * 发行人的私钥签名，签名对象是(platformPubKey_pubKey_接口名_author_name_url_displayUrl_hash_desc_flag_publishCount_seriesId_seriesBeginIndex
     * _sellStatus_sellCount_metaData_operateId)
     * 接口名：publish_nft
     */
    private String signature;
    /**
     * 平台方的私钥签名，签名对象和signature对象一致
     */
    private String platformSignature;

    private static final Nft034PublishReq obj = new Nft034PublishReq();
    private static final long serialVersionUID = -6804495011501136941L;

    public static Nft034PublishReq getNew() {
        try {
            return (Nft034PublishReq) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft034PublishReq();
        }
    }
}
