package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * xx 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2025-07-03 17:38
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MaiZhiAllVo {
    // 基础响应类
    @Data
    public static class BaseResponse<T> {
        private String msg;
        private Integer errcode;
        private T data;
    }

    // 登录授权
    @Data
    public static class AuthParam {
        private String appid;
        private String appSecret;
    }

    @Data
    public static class AuthResponse extends BaseResponse<AuthResponse.DataRes> {
        @Data
        public static class DataRes {
            private String accessToken;
            private Integer expire;
        }
    }

    // 实名
    @Data
    public static class IdCardParam {
        @ApiModelProperty(value = "姓名")
        private String name;
        @ApiModelProperty(value = "身份证")
        private String idcard;
    }

    @Data
    public static class CheckIdcardResponse {
        private String message;
        private String msg;
        private Integer result;
        private String resultDesc;
        private Integer gender;
        private Integer age;
        private String area;
        private Integer errcode;
    }

    // 新增订单
    @Data
    public static class OrderParam implements Cloneable {
        private String operationNo;
        private String out_trade_no;
        private String dgoid;
        private BigDecimal receipt_amount;
        private Integer total;
        private String payTime;
        private List<User> userList;

        @Data
        public static class User implements Cloneable {
            private String name;
            private String phone;
            private String idcard;
            private BigDecimal money;
            private static final User obj = new User();

            public static User getNew() {
                try {
                    return (User) obj.clone();
                } catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                return new User();
            }
        }
        private static final OrderParam obj = new OrderParam();

        public static OrderParam getNew() {
            try {
                return (OrderParam) obj.clone();
            } catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return new OrderParam();
        }
    }

    @Data
    public static class OrderResponse extends BaseResponse<String> {
    }

    // 订单查询
    @Data
    public static class OrderInfoParam  implements Cloneable {
        private List<String> orderList;
        private static final OrderInfoParam obj = new OrderInfoParam();

        public static OrderInfoParam getNew() {
            try {
                return (OrderInfoParam) obj.clone();
            } catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return new OrderInfoParam();
        }
    }

    @Data
    public static class OrderInfoResponse {
        private Integer errcode;
        private List<OrderList> outlist;

        @Data
        public static class OrderList {
            private String out_trade_no;
            private Integer status;
            private BigDecimal receipt_amount;
            private String time;
            private List<UserOrder> user_order;

            @Data
            public static class UserOrder {
                private String fout_trade_no;
                private Integer status;
                private String name;
                private String phone;
                private String idcard;
                private BigDecimal money;
            }
        }
    }

    // 核销码
    @Data
    public static class GenerateDeviceCodeResponse {
        private String qrcode_str;
        private Integer errcode;
    }

    // 设备编号获取
    @Data
    public static class DeviceNumberResponse {
        private List<NumberList> list;
        private Integer errcode;

        @Data
        public static class NumberList {
            private String fout_trade_no;
            private String cardno;
        }
    }

    // 设备余额
    @Data
    public static class DeviceBalanceResponse {
        private String cardno;
        private BigDecimal money;
        private String time;
        private String msg;
        private Integer errcode;
    }

    // 设备记录查询
    @Data
    public static class DeviceRecordResponse {
        private List<Record> list;
        private String msg;
        private Integer errcode;
        private String cardno;
        private Integer total;
        private Integer page;

        @Data
        public static class Record {
            private String note;
            private BigDecimal amt;
            private BigDecimal ftbal;
            private String time;
        }
    }

    // 变更设备状态
    @Data
    public static class ChangeDeviceStatusResponse implements Cloneable {
        private String msg;
        private Integer errcode;
        private Integer status;
        private String note;

        private static final ChangeDeviceStatusResponse obj = new ChangeDeviceStatusResponse();

        public static ChangeDeviceStatusResponse getNew() {
            try {
                return (ChangeDeviceStatusResponse) obj.clone();
            } catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return new ChangeDeviceStatusResponse();
        }
    }
}
