package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinGoodsExtagVo", description = "商品关联音乐人、艺人、IP信息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinGoodsExtagVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 367926424789690081L;
    @ApiModelProperty(position = 10, value = "标签ID")
    private String tagId;
    @ApiModelProperty(position = 11, value = "标签名称")
    private String tagName;
    @ApiModelProperty(position = 12, value = "标签说明")
    private String tagDesc;
    @ApiModelProperty(position = 13, value = "标签图片")
    private String tagPic;
    @ApiModelProperty(position = 14, value = "标签类型[1-音乐人|2-艺术家|3-品牌方|4-厂牌]")
    private String tagType;
    @ApiModelProperty(position = 15, value = "排序[数值越小,排序越前]")
    private Integer sort;

    public GoblinGoodsExtagVo setSort(Integer sort) {
        this.sort = sort;
        return this;
    }

    private static final GoblinGoodsExtagVo obj = new GoblinGoodsExtagVo();
    public static GoblinGoodsExtagVo getNew() {
        try {
            return (GoblinGoodsExtagVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsExtagVo();
        }
    }

    public GoblinGoodsExtagVo copy(GoblinSelfTagVo source) {
        if (null == source) return this;
        this.setTagId(source.getTagId());
        this.setTagName(source.getTagName());
        this.setTagDesc(source.getTagDesc());
        this.setTagPic(source.getTagPic());
        this.setTagType(source.getTagType());
        return this;
    }
}
