package com.liquidnet.service.platform.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.common.cache.redis.util.AbstractRedisUtil;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.dto.GoblinStoreMarketDto;
import com.liquidnet.service.goblin.dto.vo.GoblinOrderSkuVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreOrderVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;

@Component
public class GoblinRedisUtils {
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;
    public int randomMax = 10;

    private AbstractRedisUtil getRedis() {
        return redisDataSourceUtil.getRedisGoblinUtil();
    }

    public void del(String... keys) {
        getRedis().del(keys);
    }

    // 获取 订单相关vo
    public GoblinStoreOrderVo getGoblinOrder(String orderId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER.concat(orderId);
        Object obj = getRedis().get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (GoblinStoreOrderVo) obj;
        }
    }

    // 获取 订单相关Skuvo
    public GoblinOrderSkuVo getGoblinOrderSkuVo(String orderSkuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_SKU.concat(orderSkuId);
        Object obj = getRedis().get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (GoblinOrderSkuVo) obj;
        }
    }
    //获取 spu销量
    public Integer getSpuSaleCount(String spuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SALE_SPU_COUNT.concat(spuId);
        Object obj = getRedis().get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (Integer) obj;
        }
    }

    //获取 未支付的订单redis列表
    public List<String> getUnPayGoblinOrderList(String randomKey) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_UN_PAY.concat(randomKey);
        Object obj = getRedis().get(redisKey);
        if (obj == null) {
            return CollectionUtil.arrayListString();
        } else {
            return (List<String>) getRedis().get(redisKey);
        }
    }

    // 删除 未支付订单id列表
    public void removeGoblinOrder(String randomKey, String orderId) {
        if (randomKey == null) {
            for (int i = 0; i < randomMax; i++) {
                String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_UN_PAY.concat(i + "");
                List<String> list = getUnPayGoblinOrderList(randomKey);
                if (list.contains(orderId)) {
                    list.remove(orderId);
                    getRedis().set(redisKey, list);
                    break;
                }
            }
        } else {
            String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_UN_PAY.concat(randomKey + "");
            List<String> list = getUnPayGoblinOrderList(randomKey);
            list.remove(orderId);
            getRedis().set(redisKey, list);
        }
    }

    //添加库存
    public int incrSkuStock(String marketPre, String skuId, Integer stock) {
        String rk = GoblinRedisConst.REAL_STOCK_SKU;
        if (marketPre != null && !marketPre.equals("null")) {
            rk = rk.concat(marketPre + ":");
        }
        rk = rk.concat(skuId);
        return (int) getRedis().incr(rk, stock);
    }

    // 减少 用户sku购买个数
    public int decrSkuCountByUid(String uid, String skuId, int number) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_BUY_COUNT.concat(uid + ":skuId:" + skuId);
        return (int) getRedis().decr(redisKey, number);
    }

    // 赋值 订单相关vo
    public void setGoblinOrder(String orderId, GoblinStoreOrderVo vo) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER.concat(orderId);
        getRedis().set(redisKey, vo);
    }

    // 赋值 订单相关Skuvo
    public void setGoblinOrderSku(String orderSkuId, GoblinOrderSkuVo vo) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ORDER_SKU.concat(orderSkuId);
        getRedis().set(redisKey, vo);
    }

    /* ---------------------------------------- 商铺活动 ---------------------------------------- */

    public List<GoblinStoreMarketDto> getStoreMarketDtos(String storeId) {
        String rk = GoblinRedisConst.STORE_MARKETS.concat(storeId);
        String valStr = (String) getRedis().get(rk);
        List<GoblinStoreMarketDto> dtos = null;
        if (StringUtils.isEmpty(valStr)) {
            // TODO: 2022/2/17 zhanggb mongodb 查取该商品所有参与的活动并整理集合
            dtos = ObjectUtil.getGoblinStoreMarketDtoArrayList();
        } else {
            dtos = JsonUtils.fromJson(valStr, new TypeReference<List<GoblinStoreMarketDto>>() {
            });
        }
        return dtos;
    }

    public boolean addStoreMarketDto(String storeId, GoblinStoreMarketDto dto) {
        List<GoblinStoreMarketDto> dtos = this.getStoreMarketDtos(storeId);
        dtos.add(dto);
        return getRedis().set(GoblinRedisConst.STORE_MARKETS.concat(storeId), JsonUtils.toJson(dtos));
    }

    public void delStoreMarketDto(String storeId, GoblinStoreMarketDto dto) {
        String rk = GoblinRedisConst.STORE_MARKETS.concat(storeId);
        List<GoblinStoreMarketDto> dtos = this.getStoreMarketDtos(storeId);
        if (!CollectionUtils.isEmpty(dtos)) {
            int beforeSize = dtos.size();
            dtos.removeIf(r -> r.getId().equals(dto.getId()) && r.getType().equals(dto.getType()));
            if (beforeSize > dtos.size()) {
                getRedis().set(GoblinRedisConst.STORE_MARKETS.concat(storeId), JsonUtils.toJson(dtos));
            }
        }
    }

    /* ----------------------------------------  ---------------------------------------- */
    /* ----------------------------------------  ---------------------------------------- */
    /* ----------------------------------------  ---------------------------------------- */
}
