package com.liquidnet.client.admin;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.commons.lang.constant.LnsEnum;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.MD5;
import com.liquidnet.service.goblin.dto.vo.SmileSchoolVo;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dto.vo.returns.KylinOrderRefundsVo;
import com.liquidnet.service.kylin.entity.KylinOrderRefunds;
import com.liquidnet.service.smile.entity.SmileSchool;
import com.liquidnet.service.smile.mapper.SmileSchoolMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.client.result.UpdateResult;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

/**
 * Test
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestLocal {
    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    MongoConverter mongoConverter;

    @Autowired
    Environment environment;

    @Test
    public void updateAt(){
        KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
        kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_APPLY);
        kylinOrderRefunds.setApplicantId("1111");
        kylinOrderRefunds.setApplicantName("2222");
        kylinOrderRefunds.setApplicantAt(LocalDateTime.now());
        KylinOrderRefundsVo kylinOrderRefundsVo = new KylinOrderRefundsVo();
        BeanUtils.copyProperties(kylinOrderRefunds, kylinOrderRefundsVo);
        kylinOrderRefundsVo.setUpdatedAt(LocalDateTime.now());
        BasicDBObject EntitiesVov = new BasicDBObject("$set", mongoConverter.convertToMongoType(kylinOrderRefundsVo));

        UpdateResult updateResult = mongoTemplate.getCollection(KylinOrderRefundsVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderRefundsId").in("2767295925071872949890")).getQueryObject(),
                EntitiesVov
        );
    }

    @Test
    public void testMd5() {
        String str = "a=d";
        String signsign = MD5.getStrMD5(str,null);
        System.out.print(signsign);
    }

    @Test
    public void isXianshang() {
        boolean contains = Arrays.asList(LnsEnum.ENV.dev.name(), LnsEnum.ENV.test.name()).contains(environment.getProperty(CurrentUtil.CK_ENV_ACTIVE));
        System.out.println(contains);
    }

    @Autowired
    private SmileSchoolMapper smileSchoolMapper;

    @Test
    public void testSaveSmileSchoolMongodb(){
        LambdaQueryWrapper<SmileSchool> queryWrapper = Wrappers.lambdaQuery(SmileSchool.class);
        queryWrapper.eq(SmileSchool::getDelTag,0);
        List<SmileSchool> smileSchools = smileSchoolMapper.selectList(queryWrapper);
        smileSchools.forEach(smileSchool->{
            SmileSchoolVo smileSchoolVo = new SmileSchoolVo().copy(smileSchool);
            mongoTemplate.insert(smileSchoolVo, SmileSchoolVo.class.getSimpleName());
        });
    };
}
