package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 单品关联规格值
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoodsSkuSpecValue implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 商品id，对应 goblin_goods.spu_id
     */
    private String spuId;

    /**
     * 单品id，对应 goblin_goods_sku.sku_id
     */
    private String skuId;

    /**
     * 规格名称，对应 goblin_goods_spec.spec_name
     */
    private String specName;

    /**
     * 规格值名称，对应 goblin_goods_spec_value.spec_vname
     */
    private String specVname;

    /**
     * 排序，数值越小排序越前
     */
    private Integer sort;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private String delFlg;

    private String comment;


}
