package com.liquidnet.service.galaxy.router.zxin.biz;

import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftEnum;
import com.liquidnet.common.third.zxlnft.dto.*;
import com.liquidnet.common.third.zxlnft.util.ZxlWalletSdkUtil;
import com.liquidnet.common.third.zxlnft.util.ZxlnftSdkUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyErrorEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.biz.GalaxyEnumBiz;
import com.liquidnet.service.galaxy.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxinTradeBiz
 * @Package com.liquidnet.service.galaxy.router.zxin.biz
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 13:08
 */
@Slf4j
@Component
public class ZxinTradeBiz {
    @Autowired
    private ZxlnftSdkUtil zxlnftSdkUtil;

    @Autowired
    private ZxlWalletSdkUtil zxlWalletSdkUtil;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    @Autowired
    private ZxlnftConfig zxlnftConfig;

    @Autowired
    private DataUtils dataUtils;

    public ResponseDto<GalaxyNftBuyRespDto> nftBuy(GalaxyNftBuyReqDto nftBuyReqDto){
        //获取订单信息
        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(nftBuyReqDto.getRouterType(),nftBuyReqDto.getNftOrderPayId());
        if(StringUtil.isNotNull(nftOrderBo)&&StringUtil.isNotEmpty(nftOrderBo.getNftBuyTaskId())){
            return ResponseDto.failure(GalaxyErrorEnum.NFT_BUY_TASK_HAVE_EXIST.getCode(), GalaxyErrorEnum.NFT_BUY_TASK_HAVE_EXIST.getMessage());
        }

        //获取用户信息
        GalaxyUserInfoBo userInfoBo = dataUtils.getGalaxyUserInfo(nftBuyReqDto.getRouterType(),nftBuyReqDto.getUserId());

        //获取sku信息
        GalaxySeriesInfoBo seriesInfoBo = dataUtils.getSeriesInfoBo(nftBuyReqDto.getRouterType(),nftBuyReqDto.getSkuId());


        //返回参数nftId
        String nftId = null;
        if(StringUtil.isNotNull(nftOrderBo)){
            nftId = nftOrderBo.getNftId();
        }

        if(StringUtil.isNotEmpty(nftId)){
            //执行购买逻辑
            GalaxyNftBuyRespDto nftBuyRespDto = this.nftBuyBusiness(nftBuyReqDto.getRouterType(),nftId,userInfoBo,seriesInfoBo,nftOrderBo);
            return ResponseDto.success(nftBuyRespDto);
        }else{
            return ResponseDto.failure(GalaxyErrorEnum.NFT_BUY_FAIL.getCode(), GalaxyErrorEnum.NFT_BUY_FAIL.getMessage());
        }
    }

    public ResponseDto<GalaxyNftPublishAndBuyRespDto> nftPublishAndBuy(GalaxyNftPublishAndBuyReqDto reqDto) {
        //获取订单信息
        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
        if(StringUtil.isNotNull(nftOrderBo)){
            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_FAIL_ALREADY_EXIST.getCode(), GalaxyErrorEnum.PUBLISH_FAIL_ALREADY_EXIST.getMessage());
        }


        //获取用户信息
        GalaxyUserInfoBo userInfoBo = dataUtils.getGalaxyUserInfo(reqDto.getRouterType(),reqDto.getUserId());

        //获取sku信息
        GalaxySeriesInfoBo seriesInfoBo = dataUtils.getSeriesInfoBo(reqDto.getRouterType(),reqDto.getSkuId());

        String author = seriesInfoBo.getAuthor();
        String nftName = seriesInfoBo.getNftName();
        String nftUrl = seriesInfoBo.getNftUrl();
        String displayUrl = seriesInfoBo.getDisplayUrl();

        String nftDesc = seriesInfoBo.getNftDesc();
        String nftFlag = seriesInfoBo.getNftFlag();
        //发行个数
        Long publishCount = 1L;
        //开始索引
        Integer seriesBeginIndex = 0;
        //发行金额
        Long sellCount = Long.valueOf(seriesInfoBo.getSellCount().multiply(BigDecimal.valueOf(100l)).longValue()); //积分
        /**
         * 根据sku获取系列Id
         */
        String seriesId = seriesInfoBo.getSkuId();
        //返回参数nftId
        String nftId = null;


        //查询系列信息
        Nft032SeriesReqDto nft032ReqDto = Nft032SeriesReqDto.getNew();
        nft032ReqDto.setSeriesId(seriesId);
        ZxlnftResponseDto<Nft032SeriesRespDto> resp = zxlnftSdkUtil.nft032Series(nft032ReqDto);

        if(!resp.isSuccess()){
            //该系列已经发行多少个nft
            Long crtCount = resp.getData().getSeriesInfo().getCrtCount();
            log.info("系列：{} 已发行 ：{}", seriesId, crtCount);
            //设置开始索引
            seriesBeginIndex = Integer.parseInt(String.valueOf(crtCount.longValue() + 1));
        }

        //3.1.2调用NFT发行接口
        /**
         * 发行无限制系列
         */
        Nft034PublishReqDto nft034ReqDto = Nft034PublishReqDto.getNew();
        nft034ReqDto.setAuthor(author);
        nft034ReqDto.setName(nftName);
        nft034ReqDto.setUrl(nftUrl);
        nft034ReqDto.setDisplayUrl(displayUrl);
        nft034ReqDto.setDesc(nftDesc);
        nft034ReqDto.setFlag(nftFlag);
        nft034ReqDto.setPublishCount(publishCount);
        //无限制零系列
        nft034ReqDto.setSeriesId(seriesId);
        nft034ReqDto.setSeriesBeginIndex(seriesBeginIndex);
        nft034ReqDto.setSellStatus(Integer.parseInt(ZxlnftEnum.SellStatusEnum.CAN_SELL.getCode()));
        nft034ReqDto.setSellCount(sellCount);
        nft034ReqDto.setOperateId(IDGenerator.get32UUID());
        nft034ReqDto.setMetaData("");

        ZxlnftResponseDto<Nft034PublishRespDto> nft034RespDto = zxlnftSdkUtil.nft034Publish(nft034ReqDto);

        if (nft034RespDto.isSuccess()) {
            //3.1.4查询 NFT发行结果
            Nft035PublishResultReqDto nft035ReqDto = Nft035PublishResultReqDto.getNew();
            nft035ReqDto.setTaskId(nft034RespDto.getData().getTaskId());
            //休眠1秒钟，等待执行结果
            try {
                Thread.sleep(1000l);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            long timeStart = System.currentTimeMillis();
            log.info("=======执行第{}次查询,taskId:{}", 1, nft035ReqDto.getTaskId());
            ZxlnftResponseDto<Nft035PublishResultRespDto> nft035RespDto = zxlnftSdkUtil.nft035PublishResult(nft035ReqDto);

            if (nft035RespDto.isSuccess()) {
                if (nft035RespDto.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())) {
                    log.info("任务执行失败！taskId:{} taskMsg:{}", nft035ReqDto.getTaskId(), nft035RespDto.getData().getTaskMsg());
                    return null;
                }

                int count = 1;
                String nftIdBegin = nft035RespDto.getData().getNftIdBegin();

                if (nft035RespDto.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.PROCESSING.getCode())) {
                    log.info(ZxlnftEnum.TaskStatusEnum.PROCESSING.getMessage());
                    while (StringUtil.isEmpty(nftIdBegin)) {
                        //休眠1秒钟，等待执行结果
                        try {
                            Thread.sleep(1000l);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }

                        count++;
                        ZxlnftResponseDto<Nft035PublishResultRespDto> nft035RespDtoTemp = zxlnftSdkUtil.nft035PublishResult(nft035ReqDto);
                        log.info("=======执行第{}次查询,taskId:{}", count, nft035ReqDto.getTaskId());
                        if (nft035RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())) {
                            nftIdBegin = nft035RespDtoTemp.getData().getNftIdBegin();
                        } else if (nft035RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())) {
                            log.info("任务执行失败！taskId:{}", nft035ReqDto.getTaskId());
                            return null;
                        }

                        if (count == 6) {
                            log.info("=======查询共6次，跳出循环！taskId:{}", nft035ReqDto.getTaskId());
                            break;
                        }
                    }
                } else if (nft035RespDto.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())) {
                    log.info(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getMessage());
                }

                log.info("发行NFT后返回给前端nftID:{}", nftIdBegin);
                log.info("总共执行了{}次查询 总耗时:{} MS", count, (System.currentTimeMillis() - timeStart));

                if (StringUtil.isNotEmpty(nftIdBegin)) {
                    nftId = nftIdBegin;
                    //3.1.3调用NFT查询接口
                    Nft036InfoReqDto nft036ReqDto = Nft036InfoReqDto.getNew();
                    nft036ReqDto.setNftId(nftIdBegin);
                    ZxlnftResponseDto<Nft036InfoRespDto> nft036RespDto = zxlnftSdkUtil.nft036Info(nft036ReqDto);
                    log.info("调用NFT查询接口 : {}", nft036RespDto.toJson());
                }
            }
        }
        if(StringUtil.isNotEmpty(nftId)){
            //执行购买逻辑
            GalaxyNftPublishAndBuyRespDto nftPublishAndBuyRespDto = GalaxyNftPublishAndBuyRespDto.getNew();
            GalaxyNftBuyRespDto nftBuyRespDto = this.nftBuyBusiness(reqDto.getRouterType(),nftId,userInfoBo,seriesInfoBo,nftOrderBo);
            BeanUtil.copy(nftBuyRespDto,nftPublishAndBuyRespDto);
            return ResponseDto.success(nftPublishAndBuyRespDto);
        }else{
            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_FAIL.getCode(), GalaxyErrorEnum.PUBLISH_FAIL.getMessage());
        }
    }

    public ResponseDto<GalaxyNftBuyResultQueryRespDto> nftBuyResultQuery(GalaxyNftBuyResultQueryReqDto reqDto) {
        //获取订单信息
        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
        if(StringUtil.isNull(nftOrderBo)){
            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getCode(), GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getMessage());
        }

        if(StringUtil.isEmpty(nftOrderBo.getNftBuyTaskId())){
            return ResponseDto.failure(GalaxyErrorEnum.NFT_BUY_TASK_NOT_EXIST.getCode(), GalaxyErrorEnum.NFT_BUY_TASK_NOT_EXIST.getMessage());
        }
        //3.2.4查询NFT购买结果
        Nft044BuyResultReqDto nft044ReqDto = Nft044BuyResultReqDto.getNew();
        nft044ReqDto.setTaskId(nftOrderBo.getNftBuyTaskId());
        ZxlnftResponseDto<Nft044BuyResultRespDto> nft044RespDto = zxlnftSdkUtil.nft044BuyResult(nft044ReqDto);

        GalaxyNftBuyResultQueryRespDto resultQueryRespDto = GalaxyNftBuyResultQueryRespDto.getNew();
        BeanUtil.copy(nft044RespDto.getData(),resultQueryRespDto);
        String nowTimeStr = DateUtil.format(new Date(nft044RespDto.getData().getChainTimestamp().longValue()*1000),DateUtil.Formatter.yyyyMMddHHmmss);
        //转换任务状态
        Integer taskStatus = Integer.valueOf(GalaxyEnumBiz.getTaskStatusEnum(reqDto.getRouterType(),nft044RespDto.getData().getTaskStatus().toString()).getCode());
        resultQueryRespDto.setTaskStatus(taskStatus);
        resultQueryRespDto.setChainTimestamp(nowTimeStr);
        return ResponseDto.success(resultQueryRespDto);
    }

    public ResponseDto<GalaxyNftBuyPayResultQueryRespDto> nftBuyPayResultQuery(GalaxyNftBuyPayResultQueryReqDto reqDto) {
        //获取订单信息
        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
        if(StringUtil.isNull(nftOrderBo)){
            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getCode(), GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getMessage());
        }

        //3.2.5查询NFT购买支付结果
        Nft045BuyPayResultReqDto nft045ReqDto = Nft045BuyPayResultReqDto.getNew();
        nft045ReqDto.setTaskId(nftOrderBo.getNftBuyPayTaskId());
        ZxlnftResponseDto<Nft045BuyPayResultRespDto> nft045RespDto = zxlnftSdkUtil.nft045BuyPayResult(nft045ReqDto);

        GalaxyNftBuyPayResultQueryRespDto resultQueryRespDto = GalaxyNftBuyPayResultQueryRespDto.getNew();
        BeanUtil.copy(nft045RespDto.getData(),resultQueryRespDto);
        String nowTimeStr = DateUtil.format(new Date(nft045RespDto.getData().getChainTimestamp().longValue()*1000),DateUtil.Formatter.yyyyMMddHHmmss);
        //转换任务状态
        Integer taskStatus = Integer.valueOf(GalaxyEnumBiz.getTaskStatusEnum(reqDto.getRouterType(),nft045RespDto.getData().getTaskStatus().toString()).getCode());
        resultQueryRespDto.setTaskStatus(taskStatus);
        resultQueryRespDto.setChainTimestamp(nowTimeStr);
        return ResponseDto.success(resultQueryRespDto);
    }

    private GalaxyNftBuyRespDto nftBuyBusiness(String routerType,String nftId,GalaxyUserInfoBo userInfoBo, GalaxySeriesInfoBo seriesInfoBo,GalaxyNftOrderBo nftOrderBo){
//        3.2.2调用购买NFT接口
        Nft043BuyReqDto nft043BuyReqDto = Nft043BuyReqDto.getNew();
        nft043BuyReqDto.setNftId(nftId);
        nft043BuyReqDto.setApplyScore(seriesInfoBo.getSellCount().intValue());
        nft043BuyReqDto.setReceiverPubKey(userInfoBo.getUserPubKey());
        nft043BuyReqDto.setPointReceiverAddr(userInfoBo.getBlockChainAddress());
        nft043BuyReqDto.setOfferCount(seriesInfoBo.getSellCount().longValue());
        nft043BuyReqDto.setOperateId(IDGenerator.get32UUID());

        /**
         * 接收人的私钥签名，签名对象是(platformPubKey_receiverPubKey_pointReceiverAddr_applyScore_接口名_nftId_offerCount_operateId)
         * 接口名：buy_nft
         */
        String signMetaData = zxlnftConfig.getNftPlatformPubKey()
                .concat("_").concat(nft043BuyReqDto.getReceiverPubKey())
                .concat("_").concat(nft043BuyReqDto.getPointReceiverAddr())
                .concat("_").concat(nft043BuyReqDto.getApplyScore().toString())
                .concat("_").concat("buy_nft")
                .concat("_").concat(nft043BuyReqDto.getNftId())
                .concat("_").concat(nft043BuyReqDto.getOfferCount().toString())
                .concat("_").concat(nft043BuyReqDto.getOperateId());
        String signature = zxlnftBiz.createSign(userInfoBo.getUserPriKey(),signMetaData);
        nft043BuyReqDto.setSignature(signature);

        String nftBuyTaskId = null;
        ZxlnftResponseDto<Nft043BuyRespDto> nft043RespDto = zxlnftSdkUtil.nft043Buy(nft043BuyReqDto);
        if(nft043RespDto.isSuccess()){
            nftBuyTaskId = nft043RespDto.getData().getTaskId();
        }else{
            throw new LiquidnetServiceException(nft043RespDto.getCode(),nft043RespDto.getMessage());
        }

        //更新缓存数据状态
        nftOrderBo.setNftBuyTaskId(nftBuyTaskId);
        dataUtils.updateNftOrderBuyTaskId(routerType,nftOrderBo.getNftOrderPayId(),nftOrderBo);

        GalaxyNftBuyRespDto nftBuyRespDto = GalaxyNftBuyRespDto.getNew();
        nftBuyRespDto.setUserId(userInfoBo.getUserId());
        nftBuyRespDto.setNftId(null);
        return nftBuyRespDto;
    }

    /**
     * 保持线程循环查询
     * @param nftId
     * @param userInfoBo
     * @param seriesInfoBo
     * @return
     */
    private GalaxyNftBuyRespDto nftBuyBusinessBackup(String nftId,GalaxyUserInfoBo userInfoBo, GalaxySeriesInfoBo seriesInfoBo){
//        3.2.2调用购买NFT接口
        Nft043BuyReqDto nft043BuyReqDto = Nft043BuyReqDto.getNew();
        nft043BuyReqDto.setNftId(nftId);
        nft043BuyReqDto.setApplyScore(seriesInfoBo.getSellCount().intValue());
        nft043BuyReqDto.setReceiverPubKey(userInfoBo.getUserPubKey());
        nft043BuyReqDto.setPointReceiverAddr(userInfoBo.getBlockChainAddress());
        nft043BuyReqDto.setOfferCount(seriesInfoBo.getSellCount().longValue());
        nft043BuyReqDto.setOperateId(IDGenerator.get32UUID());

        /**
         * 接收人的私钥签名，签名对象是(platformPubKey_receiverPubKey_pointReceiverAddr_applyScore_接口名_nftId_offerCount_operateId)
         * 接口名：buy_nft
         */
        String signMetaData = zxlnftConfig.getNftPlatformPubKey()
                .concat("_").concat(nft043BuyReqDto.getReceiverPubKey())
                .concat("_").concat(nft043BuyReqDto.getPointReceiverAddr())
                .concat("_").concat(nft043BuyReqDto.getApplyScore().toString())
                .concat("_").concat("buy_nft")
                .concat("_").concat(nft043BuyReqDto.getNftId())
                .concat("_").concat(nft043BuyReqDto.getOfferCount().toString())
                .concat("_").concat(nft043BuyReqDto.getOperateId());
        String signature = zxlnftBiz.createSign(userInfoBo.getUserPriKey(),signMetaData);
        nft043BuyReqDto.setSignature(signature);

        ZxlnftResponseDto<Nft043BuyRespDto> nft043RespDto = zxlnftSdkUtil.nft043Buy(nft043BuyReqDto);
        if(nft043RespDto.isSuccess()){
            //3.2.4查询NFT购买结果
            Nft044BuyResultReqDto nft044ReqDto = Nft044BuyResultReqDto.getNew();
            nft044ReqDto.setTaskId(nft043RespDto.getData().getTaskId());
            long timeStart = System.currentTimeMillis();
            ZxlnftResponseDto<Nft044BuyResultRespDto> nft044RespDto = zxlnftSdkUtil.nft044BuyResult(nft044ReqDto);
            if(nft044RespDto.isSuccess()){
                int count  = 1;
                String payTaskId = null;
                while(payTaskId == null){
                    try {
                        Thread.sleep(1000l);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    count++;
                    log.info("=======执行第{}次查询,taskId:{}",1,nft044ReqDto.getTaskId());
                    ZxlnftResponseDto<Nft044BuyResultRespDto> nft044RespDtoTemp = zxlnftSdkUtil.nft044BuyResult(nft044ReqDto);
                    if(nft044RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                        payTaskId = nft044RespDtoTemp.getData().getPayTaskId();
                    }else if(nft044RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())){
                        log.info("任务执行失败！taskId:{}",nft044ReqDto.getTaskId());
                        return null;
                    }

                    if(count==6){
                        log.info("=======查询共6次，跳出循环！taskId:{}",nft044ReqDto.getTaskId());
                        break;
                    }
                }
                log.info("总共执行了多少次查询：{} 总耗时:{}",count,System.currentTimeMillis() - timeStart);
                if(StringUtil.isNotEmpty(payTaskId)){
                    //3.2.5查询NFT购买支付结果
                    Nft045BuyPayResultReqDto nft045ReqDto = Nft045BuyPayResultReqDto.getNew();
                    nft045ReqDto.setTaskId(payTaskId);
                    ZxlnftResponseDto<Nft045BuyPayResultRespDto> nft045RespDto = zxlnftSdkUtil.nft045BuyPayResult(nft045ReqDto);
                }
            }
        }
        return null;
    }
}
