package com.liquidnet.service.consumer.sweet.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.sweet.receiver.ConsumerSweetAnswerRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

import static com.liquidnet.service.base.constant.MQConst.SweetQueue.SWEET_ANSWER_INSERT;

@Configuration
public class ConsumerSweetAnswerRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerSweetAnswerRdsReceiver consumerSweetAnswerRdsReceiver;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Bean
    public List<Subscription> subscriptionSqlSAI(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.SweetQueue stream = MQConst.SweetQueue.SWEET_ANSWER_INSERT;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 3; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerSweetAnswerRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

//    /**
//     * 缺票登记
//     *
//     * @param listenerContainer
//     * @param t
//     * @return
//     */
//    private Subscription receiveSqlAnswer(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
//        return listenerContainer.receiveAutoAck(Consumer.from(SWEET_ANSWER_INSERT.getGroup(), getConsumerName(SWEET_ANSWER_INSERT.name() + t)),
//                StreamOffset.create(SWEET_ANSWER_INSERT.getKey(), ReadOffset.lastConsumed()), consumerSweetAnswerRdsReceiver);
//    }
//
//    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */
//
//    /* -------------------------------------------------------- ｜ 缺票登记 */
//
//    @Bean
//    public Subscription subscriptionSqlAnswer0(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlAnswer(listenerContainer, 0);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionSqlAnswer1(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlAnswer(listenerContainer, 1);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionSqlAnswer2(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlAnswer(listenerContainer, 2);
//        listenerContainer.start();
//        return subscription;
//    }

    /* -------------------------------------------------------- ｜  */
}
