package com.liquidnet.service.goblin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinNftPayResultVo;
import com.liquidnet.service.goblin.param.GoblinNftOrderPayAgainParam;
import com.liquidnet.service.goblin.param.GoblinNftOrderPayCallbackParam;
import com.liquidnet.service.goblin.param.GoblinNftOrderPayParam;
import com.liquidnet.service.goblin.param.GoblinNftOrderRefundCallbackParam;

/**
 * <p>
 * NFT订单表 服务类
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-03-23
 */
public interface IGoblinNftOrderService {
    ResponseDto<GoblinNftPayResultVo> checkOrder(GoblinNftOrderPayParam payParam);

    ResponseDto<GoblinNftPayResultVo> payAgain(GoblinNftOrderPayAgainParam payParam);

    ResponseDto<Integer> checkOrderResult(String orderId);

    String syncOrder(GoblinNftOrderPayCallbackParam syncOrderParam);

    String refundSyncOrder(GoblinNftOrderRefundCallbackParam refundCallbackParam);

    ResponseDto<String> exchange(String code, String uid, String deviceFrom, int orderType);

}
