package com.liquidnet.service.consumer.slowly.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.slowly.receiver.ConsumerSlimeSponsorRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

@Configuration
public class ConsumerSlimeSponsorRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerSlimeSponsorRdsReceiver consumerSlimeSponsorRdsReceiver;

    /**
     * 主办相关更新
     *
     * @param listenerContainer
     * @param t
     * @return
     */
    private Subscription receiveSqlSponsor(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.SlimeQueue.SQL_SLIME_SPONSOR.getGroup(), getConsumerName(MQConst.SlimeQueue.SQL_SLIME_SPONSOR.name() + t)),
                StreamOffset.create(MQConst.SlimeQueue.SQL_SLIME_SPONSOR.getKey(), ReadOffset.lastConsumed()), consumerSlimeSponsorRdsReceiver);
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    /* -------------------------------------------------------- ｜ 主办相关更新 */

    @Bean
    public Subscription subscriptionReceiveSqlSponsor0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlSponsor(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

//    @Bean
//    public Subscription subscriptionReceiveSqlSponsor1(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlSponsor(listenerContainer, 1);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionReceiveSqlSponsor2(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlSponsor(listenerContainer, 2);
//        listenerContainer.start();
//        return subscription;
//    }

//    @Bean
//    public Subscription subscriptionReceiveSqlSponsor3(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlSponsor(listenerContainer, 3);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionReceiveSqlSponsor4(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlSponsor(listenerContainer, 4);
//        listenerContainer.start();
//        return subscription;
//    }

    /* -------------------------------------------------------- ｜  */
}
