package com.liquidnet.service.sweet.vo;

import com.liquidnet.service.sweet.entity.SweetDoudou;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class SweetDouDouVo implements Serializable, Cloneable {

    @ApiModelProperty("doudou_id")
    private String doudouId;

    @ApiModelProperty("user_id")
    private String userId;

    @ApiModelProperty("观演人姓名")
    private String username;

    @ApiModelProperty("观演人手机号")
    private String phone;

    @ApiModelProperty("购买平台")
    private String platform;

    @ApiModelProperty("购买订单号")
    private String orderCode;

    @ApiModelProperty("想给doudou说的话")
    private String mark;

    @ApiModelProperty("状态 1已登记 2未中签 3已中签 4已核销")
    private Integer status;

    private static final SweetDouDouVo obj = new SweetDouDouVo();

    public static SweetDouDouVo getNew() {
        try {
            return (SweetDouDouVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetDouDouVo();
        }
    }

    public SweetDouDouVo copy(SweetDoudou source) {
        if (null == source) return this;
        this.setPhone(source.getPhone());
        return this;
    }

}
