package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualTFCDto;
import com.liquidnet.service.sweet.entity.SweetManualTFC;
import com.liquidnet.service.sweet.mapper.SweetManualTFCMapper;
import com.liquidnet.service.sweet.service.ISweetManualTFCService;
import com.liquidnet.service.sweet.utils.RedisTFCDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 电子宣传手册表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetManualTFCServiceImpl extends ServiceImpl<SweetManualTFCMapper, SweetManualTFC> implements ISweetManualTFCService {

    @Autowired
    private SweetManualTFCMapper sweetManualTFCMapper;
    @Autowired
    private RedisTFCDataUtils redisDataUtils;

    @Override
    public ResponseDto<PageInfo<SweetManualTFCDto>> getManualList(int page, int size, String name) {
        PageInfo<SweetManualTFCDto> pageInfoTmp;
        try {
            PageHelper.startPage(page, size);
            HashMap<String, Object> map = CollectionUtil.mapStringObject();
            map.put("title", name);
            List<SweetManualTFCDto> voList = sweetManualTFCMapper.getManualList(map);
            for (int i = 0; i < voList.size(); i++) {
                SweetManualTFCDto vo = voList.get(i);
                if (vo.getStatus() >= 6 && vo.getStatus() != 7) {
                    if (DateUtil.compareStrDay(vo.getTimeSell(), DateUtil.getNowTime()) > 0) {//未开始
                        vo.setStatus(9);
                    } else if (DateUtil.compareStrDay(vo.getTimeStop(), DateUtil.getNowTime()) < 0) {//已结束
                        vo.setStatus(10);
                    } else {
                        vo.setStatus(6);
                    }
                }
            }
            pageInfoTmp = new PageInfo(voList);
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure(ErrorMapping.get(20104));
        }
        return ResponseDto.success(pageInfoTmp);
    }

    @Override
    public ResponseDto<SweetManualTFCDto> details(String manualId) {
        SweetManualTFCDto vo;
        try {
            HashMap<String, Object> map = CollectionUtil.mapStringObject();
            map.put("manualId", manualId);
            vo = sweetManualTFCMapper.getManualDetails(map);
            if (vo.getStatus() >= 6 && vo.getStatus() != 7) {
                if (DateUtil.compareStrDay(vo.getTimeSell(), DateUtil.getNowTime()) > 0) {//未开始
                    vo.setStatus(9);
                } else if (DateUtil.compareStrDay(vo.getTimeStop(), DateUtil.getNowTime()) < 0) {//已结束
                    vo.setStatus(10);
                } else {
                    vo.setStatus(6);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure(ErrorMapping.get(20104));
        }
        return ResponseDto.success(vo);
    }

    @Override
    public ResponseDto<Boolean> changeStatus(String manualId, String performancesId, Integer status) {
        try {
            int count = sweetManualTFCMapper.selectCount(Wrappers.lambdaUpdate(SweetManualTFC.class).eq(SweetManualTFC::getManualId, manualId));
            SweetManualTFC sweetManual = SweetManualTFC.getNew();
            if (count > 0) {//修改
                sweetManual.setStatus(status);
                sweetManual.setUpdatedAt(LocalDateTime.now());
                sweetManualTFCMapper.update(sweetManual, Wrappers.lambdaUpdate(SweetManualTFC.class).eq(SweetManualTFC::getManualId, manualId));
            } else {//创建
                sweetManual.setManualId(IDGenerator.nextSnowId());
                sweetManual.setPerformanceId(performancesId);
                sweetManual.setStatus(status);
                sweetManual.setIsRelease(0);
                sweetManual.setCreatedAt(LocalDateTime.now());
                sweetManualTFCMapper.insert(sweetManual);
            }
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        redisDataUtils.deletePushListRedisData();
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> changeRelease(String manualId, Integer isRelease) {
        try {
            SweetManualTFC sweetManual = SweetManualTFC.getNew();
            sweetManual.setIsRelease(isRelease);
            sweetManual.setUpdatedAt(LocalDateTime.now());
            sweetManualTFCMapper.update(sweetManual, Wrappers.lambdaUpdate(SweetManualTFC.class).eq(SweetManualTFC::getManualId, manualId));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        redisDataUtils.deletePushListRedisData();
        return ResponseDto.success();
    }

}
