package com.liquidnet.service.goblin.service.manage;

import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.goblin.dto.manage.*;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;

import java.util.List;
import java.util.Map;

public interface IGoblinstoreMgtGoodsService {
    /**
     * 商品管理:SPU列表
     *
     * @param mgtGoodsFilterParam GoblinStoreMgtGoodsFilterParam
     * @return PagedResult<GoblinStoreMgtGoodsVo>
     */
    PagedResult<GoblinStoreMgtGoodsListVo> goodsList(GoblinStoreMgtGoodsFilterParam mgtGoodsFilterParam);

    /**
     * 商品管理:SPU添加
     *
     * @param goodsInfoVo        GoblinGoodsInfoVo
     * @param goodsSkuInfoVoList List<GoblinGoodsSkuInfoVo>
     */
    void goodsAdd(GoblinGoodsInfoVo goodsInfoVo, List<GoblinGoodsSkuInfoVo> goodsSkuInfoVoList);

    /**
     * 商品管理:SPU添加-数字藏品
     *
     * @param goodsInfoVo GoblinGoodsInfoVo
     */
    void digitalGoodsAdd(GoblinGoodsInfoVo goodsInfoVo);

    /**
     * 商品管理:SPU详情
     *
     * @param storeId 店铺ID
     * @param spuId   商品ID
     * @return GoblinStoreMgtGoodsInfoVo
     */
    GoblinStoreMgtGoodsInfoVo goodsInfo(String storeId, String spuId);

    /**
     * 商品管理:商品编辑:SPU编辑
     *
     * @param uid              UID
     * @param mgtGoodsAddParam GoblinStoreMgtGoodsAddParam
     * @param goodsInfoVo      GoblinGoodsInfoVo
     * @return boolean
     */
    boolean goodsEditSpu(String uid, GoblinStoreMgtGoodsAddParam mgtGoodsAddParam, GoblinGoodsInfoVo goodsInfoVo);

    /**
     * 商品管理:商品编辑:SPU编辑
     *
     * @param uid                     UID
     * @param mgtDigitalGoodsAddParam GoblinStoreMgtDigitalGoodsAddParam
     * @param goodsInfoVo             GoblinGoodsInfoVo
     * @return boolean
     */
    boolean digitalGoodsEditSpu(String uid, GoblinStoreMgtDigitalGoodsAddParam mgtDigitalGoodsAddParam, GoblinGoodsInfoVo goodsInfoVo);

    /**
     * 商品管理:商品编辑:SKU编辑
     *
     * @param uid                  UID
     * @param mgtGoodsEditSkuParam GoblinStoreMgtGoodsEditSkuParam
     * @param mgtGoodsSkuInfoVo    GoblinGoodsSkuInfoVo
     * @param goodsInfoVo          GoblinGoodsInfoVo
     * @param delSpuSpecMap        Map<String, String>
     * @param addSpuSpecMap        Map<String, String>
     * @return boolean
     */
    boolean goodsEditSku(String uid, GoblinStoreMgtGoodsEditSkuParam mgtGoodsEditSkuParam, GoblinGoodsSkuInfoVo mgtGoodsSkuInfoVo,
                         GoblinGoodsInfoVo goodsInfoVo, Map<String, String> delSpuSpecMap, Map<String, String> addSpuSpecMap);

    /**
     * 商品管理:商品编辑:SKU编辑-数字藏品
     *
     * @param uid                        UID
     * @param mgtDigitalGoodsAddSkuParam GoblinStoreMgtDigitalGoodsAddSkuParam
     * @param mgtGoodsInfoVo             GoblinGoodsInfoVo
     * @return boolean
     */
    boolean digitalGoodsEditSku(String uid, GoblinStoreMgtDigitalGoodsAddSkuParam mgtDigitalGoodsAddSkuParam, GoblinGoodsInfoVo mgtGoodsInfoVo);

    /**
     * 商品管理:商品编辑:SKU添加
     *
     * @param uid                  UID
     * @param mgtGoodsEditSkuParam GoblinStoreMgtGoodsEditSkuParam
     * @param goodsInfoVo          GoblinGoodsInfoVo
     */
    void goodsEditSkuAdd(String uid, GoblinStoreMgtGoodsEditSkuParam mgtGoodsEditSkuParam, GoblinGoodsInfoVo goodsInfoVo);

    /**
     * 商品管理:商品编辑:SKU添加-数字藏品
     *
     * @param uid                UID
     * @param initGoodsSkuInfoVo GoblinGoodsSkuInfoVo
     * @param mgtGoodsInfoVo     GoblinGoodsInfoVo
     */
    void digitalGoodsAddSku(String uid, GoblinGoodsSkuInfoVo initGoodsSkuInfoVo, GoblinGoodsInfoVo mgtGoodsInfoVo);

    /**
     * 商品管理:商品编辑:SKU删除
     *
     * @param uid            UID
     * @param goodsSkuInfoVo GoblinGoodsSkuInfoVo
     * @param mgtGoodsInfoVo GoblinGoodsInfoVo
     * @return boolean
     */
    boolean goodsEditSkuDel(String uid, GoblinGoodsSkuInfoVo goodsSkuInfoVo, GoblinGoodsInfoVo mgtGoodsInfoVo);

//    /**
//     * 商品管理:商品编辑:SKU批改
//     *
//     * @param spuId       商品ID
//     * @param batField    批量修改属性
//     * @param batFieldVal 批量修改属性值
//     * @return boolean
//     */
//    boolean goodsEditSkuBat(String spuId, String batField, String batFieldVal);

    /**
     * 商品管理:上下架商品
     *
     * @param mgtGoodsActionParam GoblinStoreMgtGoodsActionParam
     * @param uid                 UID
     * @param shelvesFlg          true:上架|false:下架
     * @param spuNoList           操作SPUID对应SPUNO列表
     * @return boolean
     */
    boolean goodsShelvesProcessing(GoblinStoreMgtGoodsActionParam mgtGoodsActionParam, String uid, boolean shelvesFlg, List<String> spuNoList);

    /**
     * 商品管理:上下架商品-单品
     *
     * @param mgtGoodsSkuActionParam GoblinStoreMgtGoodsSkuActionParam
     * @param uid                    UID
     * @param shelvesFlg             true:上架|false:下架
     * @return boolean
     */
    boolean goodsSkuShelvesProcessing(GoblinStoreMgtGoodsSkuActionParam mgtGoodsSkuActionParam, String uid, boolean shelvesFlg);

    /**
     * 商品管理:删除商品
     *
     * @param mgtGoodsActionParam GoblinStoreMgtGoodsActionParam
     * @param uid                 UID
     * @param spuNoList           操作SPUID对应SPUNO列表
     * @return boolean
     */
    boolean goodsRemove(GoblinStoreMgtGoodsActionParam mgtGoodsActionParam, String uid, List<String> spuNoList);

    /**
     * 商品管理:删除商品-单品
     *
     * @param mgtGoodsSkuActionParam GoblinStoreMgtGoodsSkuActionParam
     * @param uid                    UID
     * @return boolean
     */
    boolean goodsSkuRemove(GoblinStoreMgtGoodsSkuActionParam mgtGoodsSkuActionParam, String uid);
}
