package com.liquidnet.service.stone.dto;

//import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class StoneScoreListDto implements Cloneable {
    /**
     * 昵称
     */
    private String nickName;
    /**
     * 头像
     */
    private String avatar;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * 用户id
     */
    private String uid;
    /**
     * 状态[-999-全部|1-正常|2-冻结]
     */
    private Integer status;
    /**
     * 总积分
     */
    private BigDecimal scoreAll;
    /**
     * 已用积分
     */
    private BigDecimal scoreUse;
    /**
     * 剩余积分
     */
    private BigDecimal scoreRest;

    /**
     * 今日是否签到
     */
    private Integer signIn;

    private static final StoneScoreListDto obj = new StoneScoreListDto();
    public static StoneScoreListDto getNew() {
        try {
            return (StoneScoreListDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new StoneScoreListDto();
    }
}
