package com.liquidnet.service.consumer.goblin.config;

import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.goblin.receiver.ConsumerGoblinSqlGoodsRdsReceiver;
import com.liquidnet.service.consumer.goblin.receiver.ConsumerGoblinSqlStoreRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

import static com.liquidnet.service.base.constant.MQConst.AdamQueue;

@Configuration
public class ConsumerGoblinSqlUstoreRedisStreamConfig {
    @Autowired
    ConsumerGoblinSqlStoreRdsReceiver consumerGoblinSqlStoreRdsReceiver;
    @Autowired
    ConsumerGoblinSqlGoodsRdsReceiver consumerGoblinSqlGoodsRdsReceiver;

    private StreamMessageListenerContainer<String, MapRecord<String, String, String>> buildStreamMessageListenerContainer(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        return StreamMessageListenerContainer.create(factory, options);
    }

    /**
     * 店铺相关
     *
     * @param listenerContainer StreamMessageListenerContainer
     * @param t                 消费者序号
     * @return Subscription
     */
    private Subscription receiveSqlStore(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(
                Consumer.from(MQConst.GoblinQueue.SQL_STORE.getGroup(), MQConst.GoblinQueue.SQL_STORE.name() + t),
                StreamOffset.create(MQConst.GoblinQueue.SQL_STORE.getKey(), ReadOffset.lastConsumed()), consumerGoblinSqlStoreRdsReceiver
        );
    }

    /**
     * 商品相关
     *
     * @param listenerContainer StreamMessageListenerContainer
     * @param t                 消费者序号
     * @return Subscription
     */
    private Subscription receiveSqlGoods(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(
                Consumer.from(MQConst.GoblinQueue.SQL_GOODS.getGroup(), MQConst.GoblinQueue.SQL_GOODS.name() + t),
                StreamOffset.create(MQConst.GoblinQueue.SQL_GOODS.getKey(), ReadOffset.lastConsumed()), consumerGoblinSqlGoodsRdsReceiver
        );
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    /* -------------------------------------------------------- ｜ 店铺相关 */

    @Bean
    public Subscription subscriptionSqlStore1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlStore(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlStore2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlStore(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlStore3(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlStore(listenerContainer, 3);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜ 用户中心 */

    @Bean
    public Subscription subscriptionSqlGoods1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlGoods(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlGoods2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlGoods(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlGoods3(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlGoods(listenerContainer, 3);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜  */
}
