package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.service.adam.entity.AdamRealName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamRealInfoVo", description = "实名信息")
@JsonIgnoreProperties(value = {"uid"})
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class AdamRealInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -3469256375584132928L;
    @ApiModelProperty(position = 10, value = "用户ID[30]")
    private String uid;
    @ApiModelProperty(position = 11, value = "姓名[30]")
    private String name;
    @ApiModelProperty(position = 12, value = "证件号[50]")
    private String idCard;
    @ApiModelProperty(position = 13, value = "类型[1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证]")
    private Integer type;
    @ApiModelProperty(position = 14, value = "状态:1-正常")
    private Integer state;

    private static final AdamRealInfoVo obj = new AdamRealInfoVo();

    public static AdamRealInfoVo getNew() {
        try {
            return (AdamRealInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamRealInfoVo();
        }
    }

    public AdamRealInfoVo copy(AdamRealName source) {
        if (null == source) return this;
        this.setUid(source.getUid());
        this.setName(source.getName());
        this.setIdCard(source.getIdCard());
        this.setType(source.getType());
        this.setState(source.getState());
        return this;
    }
}
