package com.liquidnet.service.sweet.dto.vo;

import com.liquidnet.service.candy.vo.CandyCouponBasicVo;
import com.liquidnet.service.candy.vo.CandyCouponRulesVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
public class IntegralActivityCouponVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -3363640191417806822L;

    @ApiModelProperty(value = "券id")
    private String couponId;
    @ApiModelProperty(value = "标题")
    private String title;
    @ApiModelProperty(value = "标注")
    private String label;
    @ApiModelProperty(value = "须知")
    private String notice;
    @ApiModelProperty(value = "业务类别[0-全场｜1-演出｜2-商品｜3-优先购]")
    private Integer busiType;
    @ApiModelProperty(value = "券类型[1-代金券｜2-满减券｜3-兑换券｜4-折扣券 | 101-优先券]")
    private Integer couType;
    @ApiModelProperty(value = "[0-用户输入兑换｜1-发放至用户｜2-积分商品｜3-发放需领取｜4-会员专属]")
    private Integer bindType;
    @ApiModelProperty(value = "折扣")
    private BigDecimal discount;
    @ApiModelProperty(value = "面值")
    private BigDecimal valFace;
    @ApiModelProperty(value = "满减~满")
    private BigDecimal valOver;
    @ApiModelProperty(value = "满减~减")
    private BigDecimal valMinus;
    @ApiModelProperty(value = "过期时间")
    private String expireAt;
    /* --- --- --- CandyCouponRule */
    private List<CandyCouponRulesVo> useRules;

    private static final IntegralActivityCouponVo obj = new IntegralActivityCouponVo();

    public static IntegralActivityCouponVo getNew() {
        try {
            return (IntegralActivityCouponVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new IntegralActivityCouponVo();
        }
    }

    public IntegralActivityCouponVo copy(CandyCouponBasicVo source) {
        if (null == this) return this;
        this.setTitle(source.getTitle());
        this.setLabel(source.getLabel());
        this.setNotice(source.getNotice());
        this.setBusiType(source.getBusiType());
        this.setCouType(source.getCouType());
        this.setBindType(source.getBindType());
        this.setDiscount(source.getDiscount());
        this.setValFace(source.getValFace());
        this.setValOver(source.getValOver());
        this.setValMinus(source.getValMinus());
        this.setExpireAt(source.getExpireAt());
        this.setUseRules(source.getUseRules());
        return this;
    }

}
