package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualNotify;
import com.liquidnet.service.sweet.entity.SweetManualNotifyMdsk;
import com.liquidnet.service.sweet.mapper.SweetManualNotifyMdskMapper;
import com.liquidnet.service.sweet.service.ISweetManualNotifyMdskService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.sweet.utils.RedisMDSKDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 电子宣传手册通知表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetManualNotifyMdskServiceImpl extends ServiceImpl<SweetManualNotifyMdskMapper, SweetManualNotifyMdsk> implements ISweetManualNotifyMdskService {

    @Autowired
    private SweetManualNotifyMdskMapper sweetManualNotifyMdskMapper;
    @Autowired
    private RedisMDSKDataUtils redisDataUtils;

    @Override
    public ResponseDto<PageInfo<SweetManualNotifyMdsk>> getList(Integer page, Integer size, String title, String manualId) {
        PageInfo<SweetManualNotifyMdsk> pageInfo = null;
        try {
            PageHelper.startPage(page, size);
            List<SweetManualNotifyMdsk> data;
            if (title != null) {
                data = sweetManualNotifyMdskMapper.selectList(Wrappers.lambdaQuery(SweetManualNotifyMdsk.class).like(SweetManualNotifyMdsk::getTitle, title).eq(SweetManualNotifyMdsk::getManualId, manualId).eq(SweetManualNotifyMdsk::getStatus, 1));
            } else {
                data = sweetManualNotifyMdskMapper.selectList(Wrappers.lambdaQuery(SweetManualNotifyMdsk.class).eq(SweetManualNotifyMdsk::getManualId, manualId).eq(SweetManualNotifyMdsk::getStatus, 1));
            }
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        } catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String title, String content) {
        try {
            SweetManualNotifyMdsk sweetManualNotify = SweetManualNotifyMdsk.getNew();
            sweetManualNotify.setManualNotifyId(IDGenerator.nextSnowId());
            sweetManualNotify.setManualId(manualId);
            sweetManualNotify.setTitle(title);
            sweetManualNotify.setContent(content);
            sweetManualNotify.setCreatedAt(LocalDateTime.now());
            sweetManualNotifyMdskMapper.insert(sweetManualNotify);

            List<SweetManualNotifyMdsk> oldData = redisDataUtils.getNotifyRedisData(manualId);
            oldData.add(sweetManualNotify);
            redisDataUtils.setNotifyRedisData(manualId, oldData);

            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<SweetManualNotifyMdsk> details(String manualNotifyId) {
        try {
            return ResponseDto.success(sweetManualNotifyMdskMapper.selectOne(Wrappers.lambdaQuery(SweetManualNotifyMdsk.class).eq(SweetManualNotifyMdsk::getManualNotifyId, manualNotifyId).eq(SweetManualNotifyMdsk::getStatus, 1)));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> change(String manualId, String manualNotifyId, String title, String content) {
        try {
            SweetManualNotifyMdsk sweetManualNotify = SweetManualNotifyMdsk.getNew();
            sweetManualNotify.setTitle(title);
            sweetManualNotify.setContent(content);
            sweetManualNotify.setUpdatedAt(LocalDateTime.now());
            sweetManualNotifyMdskMapper.update(sweetManualNotify, Wrappers.lambdaUpdate(SweetManualNotifyMdsk.class).eq(SweetManualNotifyMdsk::getManualNotifyId, manualNotifyId));

            List<SweetManualNotifyMdsk> oldData = redisDataUtils.getNotifyRedisData(manualId);
            for (SweetManualNotifyMdsk item : oldData) {
                if (item.getManualNotifyId().equalsIgnoreCase(manualNotifyId)) {
                    item.setTitle(title);
                    item.setContent(content);
                    item.setUpdatedAt(LocalDateTime.now());
                }
            }
            redisDataUtils.setNotifyRedisData(manualId, oldData);

            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> delete(String manualNotifyId) {
        try {
            SweetManualNotifyMdsk sweetManualNotify = SweetManualNotifyMdsk.getNew();
            sweetManualNotify.setStatus(0);
            sweetManualNotify.setUpdatedAt(LocalDateTime.now());
            sweetManualNotifyMdskMapper.update(sweetManualNotify, Wrappers.lambdaUpdate(SweetManualNotifyMdsk.class).eq(SweetManualNotifyMdsk::getManualNotifyId, manualNotifyId));
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

}
