package com.liquidnet.service.goblin.dto.manage.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "GoblinStoreMgtThumbVo", description = "店铺简易信息列表")
@Data
public class GoblinStoreMgtThumbVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -7808265282707179941L;
    @ApiModelProperty(position = 10, value = "店铺ID[64]")
    private String storeId;
    @ApiModelProperty(position = 11, value = "店铺名称[128]")
    private String storeName;
    @ApiModelProperty(position = 12, value = "店铺LOGO[256]")
    private String logoPic;
    @ApiModelProperty(position = 13, value = "店铺状态[0-填写资料中|1-店铺审核中|2-审核不通过|3-审核通过|4-停业|5-营业]")
    private String status;
    @ApiModelProperty(position = 14, value = "店铺类型[1-普通店铺|2-加盟|3-连锁|5-直营]")
    private String storeType;
    @ApiModelProperty(position = 15, value = "认证类型[1-企业/公司|2-个体工商户]")
    private String certType;

    private static final GoblinStoreMgtThumbVo obj = new GoblinStoreMgtThumbVo();
    public static GoblinStoreMgtThumbVo getNew() {
        try {
            return (GoblinStoreMgtThumbVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreMgtThumbVo();
        }
    }

    public GoblinStoreMgtThumbVo copy(GoblinStoreInfoVo source) {
        if (null == source) return this;
        this.setStoreId(source.getStoreId());
        this.setStoreName(source.getStoreName());
        this.setLogoPic(source.getLogoPic());
        this.setStatus(source.getStatus());
        this.setStoreType(source.getStoreType());
        this.setCertType(source.getCertType());
        return this;
    }
}
