package com.liquidnet.client.admin.web.controller.zhengzai.goblin;


import com.alibaba.fastjson.JSON;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.goblin.service.impl.GoblinFrontMoudleIndexServiceImpl;
import com.liquidnet.service.goblin.entity.GoblinFrontMoudleIndex;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 组件排序 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-06
 */
@Api(tags = "组件排序")
@RestController
@RequestMapping("/front-index")
public class GoblinFrontMoudleIndexController extends BaseController {
    @Autowired
    GoblinFrontMoudleIndexServiceImpl goblinFrontMoudleIndexService;

    @PostMapping("update")
    @ApiOperation(value = "修改组件")
    @ResponseBody
    public AjaxResult update(@RequestBody GoblinFrontMoudleIndex goblinFrontMoudleIndex) {
        logger.info("修改组件{}", JSON.toJSONString(goblinFrontMoudleIndex));
        boolean result=goblinFrontMoudleIndexService.upadteGoblinFrontMoudleIndex(goblinFrontMoudleIndex);
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }
    /**
     * @author zhangfuxin
     * @Description:列表
     * @date 2022/1/6 下午2:04
     */
    @PostMapping("list")
    @ApiOperation(value = "组件排序列表")
    @ResponseBody
    public AjaxResult list() {
        return AjaxResult.success(goblinFrontMoudleIndexService.listGoblinFrontMoudleIndex());
    }
}
