package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontCompilationsService;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontCompilations;
import com.liquidnet.service.goblin.mapper.GoblinFrontCompilationsMapper;
import com.mongodb.BasicDBObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 合集 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-06
 */
@Service
public class GoblinFrontCompilationsServiceImpl extends ServiceImpl<GoblinFrontCompilationsMapper, GoblinFrontCompilations> implements IGoblinFrontCompilationsService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    GoblinFrontCompilationsMapper goblinFrontCompilationsMapper;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    public boolean create(GoblinFrontCompilations goblinFrontCompilations){
        goblinFrontCompilations.setCreateTime(LocalDateTime.now());
        //设置bannerid
        goblinFrontCompilations.setCompilationsId(IDGenerator.nextSnowId());
        goblinFrontCompilationsMapper.insert(goblinFrontCompilations);
        return true;
    }
    public boolean update(GoblinFrontCompilations goblinFrontCompilations){
        goblinFrontCompilations.setUpdateTime(LocalDateTime.now());
        //数据库修改
        goblinFrontCompilationsMapper.updateById(goblinFrontCompilations);
        return true;
    }
    public GoblinFrontCompilations getOne(Long id){
        return  goblinFrontCompilationsMapper.selectById(id);
    }
    public boolean delte(Long id){
        GoblinFrontCompilations goblinFrontCompilations=goblinFrontCompilationsMapper.selectById(id);
        goblinFrontCompilations.setDelTag(1);
        this.update(goblinFrontCompilations);
        return true;
    }
    public PageInfo<GoblinFrontCompilations> page(int pageSize, int pageNumber) {
        PageInfo<GoblinFrontCompilations> pageInfoTmp = null;
        try {
            PageHelper.startPage(pageNumber, pageSize);
            LambdaQueryWrapper<GoblinFrontCompilations> queryWrapper = Wrappers.lambdaQuery(GoblinFrontCompilations.class);
            queryWrapper.orderByDesc(GoblinFrontCompilations::getCreateTime);
            List<GoblinFrontCompilations> list=goblinFrontCompilationsMapper.selectList(queryWrapper);
            pageInfoTmp = new PageInfo(list);
        } catch (Exception e) {
            return new PageInfo();
        }
        return pageInfoTmp;
    }
    public boolean online(){
        //mysql 获取list
        LambdaQueryWrapper<GoblinFrontCompilations> queryWrapper = Wrappers.lambdaQuery(GoblinFrontCompilations.class);
        queryWrapper.orderByDesc(GoblinFrontCompilations::getCreateTime);
        List<GoblinFrontCompilations> list=goblinFrontCompilationsMapper.selectList(queryWrapper);
        // mongodb
        for(GoblinFrontCompilations goblinFrontCompilations:list){
            GoblinFrontCompilations goblinFrontCompilations1= mongoTemplate.findOne(Query.query(Criteria.where("compilationsId").is(goblinFrontCompilations.getCompilationsId())), GoblinFrontCompilations.class, GoblinFrontCompilations.class.getSimpleName());
            if(null==goblinFrontCompilations1){
                mongoTemplate.save(goblinFrontCompilations,GoblinFrontCompilations.class.getSimpleName());
            }else{
                BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontCompilations1)));
                mongoTemplate.getCollection(GoblinFrontCompilations.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("compilationsId").is(goblinFrontCompilations.getCompilationsId())).getQueryObject(),
                        orderObject
                );
            }
        }
        for(GoblinFrontCompilations goblinFrontCompilations:list){
            redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.COMPLIATIONS+goblinFrontCompilations.getMid(),goblinFrontCompilations);
        }
        return true;
    }
}
