package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreOrderVo;
import com.liquidnet.service.goblin.service.IGoblinOrderAppService;
import com.liquidnet.service.goblin.util.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class GoblinOrderAppServiceImpl implements IGoblinOrderAppService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinOrderUtils orderUtils;


    @Override
    public ResponseDto<List<GoblinStoreOrderVo>> orderList(int page) {
        String uid = CurrentUtil.getCurrentUid();
        List<GoblinStoreOrderVo> orderVoList = ObjectUtil.getGoblinStoreOrderVoArrayList();
        List<String> orderIds = redisUtils.getOrderList(uid);
        int size = 40;
        int initCount = (page - 1) * size;
        int finalCount = page * size;
        if (finalCount >= orderIds.size()) {
            finalCount = orderIds.size();
        }
        for (int i = initCount; i < finalCount; i++) {
            String orderId = orderIds.get(i);
            GoblinStoreOrderVo vo = redisUtils.getGoblinOrder(orderId);
            orderVoList.add(vo);
        }
        return ResponseDto.success(orderVoList);
    }

    @Override
    public ResponseDto<GoblinStoreOrderVo> orderDetails(String orderId) {
        String uid = CurrentUtil.getCurrentUid();
        GoblinStoreOrderVo vo = redisUtils.getGoblinOrder(orderId);
        if (!vo.getUserId().equals(uid)) {
            return ResponseDto.failure("无权查看");
        }
        return ResponseDto.success(vo);
    }
}
