package com.liquidnet.service.goblin.constant;

public class GoblinStatusConst {
    /* ----------------------------------------------------------------- */
    public enum CommonStatus {
        COMMON_LIMIT_UN(0, "不限购"),
        COMMON_TYPE_ALL(0, "购买条件-全部用户"),
        COMMON_TYPE_MEMBER(1, "购买条件-会员用户"),
        COMMON_TYPE_CAN(2, "购买条件-指定用户"),
        ;
        private final int value;
        private final String desc;

        CommonStatus(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public int getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum OrderStatus {
        ORDER_STATUS_0(0, "待付款(用户刚下单)"),
        ORDER_STATUS_2(2, "代发货(用户付完款 等待商城发货)"),
        ORDER_STATUS_3(3, "代收货(商城已经发货 等待用户确认收货)"),
        ORDER_STATUS_4(4, "已完成(用户已经确认收货 订单结束)"),
        ORDER_STATUS_5(5, "取消订单(用户未付款前取消订单)"),
        ORDER_STATUS_6(6, "退款通过(用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款)"),
        ORDER_STATUS_7(7, "退货通过(用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品)"),
        ORDER_STATUS_61(61, "发起-退款通过(用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款)"),
        ORDER_STATUS_71(71, "发起-退货通过(用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品)"),
        ;

        private final int value;
        private final String desc;

        OrderStatus(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public int getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum MarketingStatus {
        SELF_TYPE_ZHENGZAI(1, "正在下单"),

        STORE_TYPE_PURCHASE(2, "限时秒杀"),

        STORE_PURCHASE_STATUS_ALL(-1, "全部"),
        STORE_PURCHASE_STATUS_UN_START(0, "等待开始"),
        STORE_PURCHASE_STATUS_ING_START(1, "活动中"),
        STORE_PURCHASE_STATUS_END_START(2, "活动结束"),
        STORE_PURCHASE_STATUS_STOP(7, "停用"),
        ;
        private final int value;
        private final String desc;

        MarketingStatus(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public int getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum MarketPreStatus {
        MARKET_PRE_ZHENGZAI("ZZ", "正在下单前缀"),
        MARKET_PRE_PURCHASE("PC", "限时秒杀前缀"),
        ;

        private final String value;
        private final String desc;

        MarketPreStatus(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }

        public static String getPre(String goblinId) {
            if (goblinId.contains(MARKET_PRE_ZHENGZAI.getValue())) {
                return MARKET_PRE_ZHENGZAI.getValue();
            } else if (goblinId.contains(MARKET_PRE_PURCHASE.getValue())) {
                return MARKET_PRE_PURCHASE.getValue();
            }
            return null;
        }
    }


    /* ----------------------------------------------------------------- */



    /* ----------------------------------------------------------------- */
}
